/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.world.structure;

import com.iafenvoy.iceandfire.config.IafCommonConfig;
import com.iafenvoy.iceandfire.entity.EntityPixie;
import com.iafenvoy.iceandfire.item.block.BlockPixieHouse;
import com.iafenvoy.iceandfire.registry.IafBlocks;
import com.iafenvoy.iceandfire.registry.IafEntities;
import com.iafenvoy.iceandfire.registry.IafStructurePieces;
import com.iafenvoy.iceandfire.registry.IafStructureTypes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;

public class PixieVillageStructure
extends Structure {
    public static final MapCodec<PixieVillageStructure> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)PixieVillageStructure.settingsCodec((RecordCodecBuilder.Instance)instance)).apply((Applicative)instance, PixieVillageStructure::new));

    protected PixieVillageStructure(Structure.StructureSettings config) {
        super(config);
    }

    protected Optional<Structure.GenerationStub> findGenerationPoint(Structure.GenerationContext context) {
        if (context.random().nextDouble() >= (Double)IafCommonConfig.INSTANCE.worldGen.generatePixieVillageChance.getValue()) {
            return Optional.empty();
        }
        Rotation blockRotation = Rotation.getRandom((RandomSource)context.random());
        BlockPos blockPos = this.getLowestYIn5by5BoxOffset7Blocks(context, blockRotation);
        return Optional.of(new Structure.GenerationStub(blockPos, collector -> collector.addPiece((StructurePiece)new PixieVillagePiece(0, new BoundingBox(blockPos.getX(), blockPos.getY(), blockPos.getZ(), blockPos.getX(), blockPos.getY(), blockPos.getZ())))));
    }

    public StructureType<?> type() {
        return (StructureType)IafStructureTypes.PIXIE_VILLAGE.get();
    }

    public static class PixieVillagePiece
    extends StructurePiece {
        protected PixieVillagePiece(int length, BoundingBox boundingBox) {
            super((StructurePieceType)IafStructurePieces.PIXIE_VILLAGE.get(), length, boundingBox);
        }

        public PixieVillagePiece(StructurePieceSerializationContext context, CompoundTag nbt) {
            super((StructurePieceType)IafStructurePieces.PIXIE_VILLAGE.get(), nbt);
        }

        protected void addAdditionalSaveData(StructurePieceSerializationContext context, CompoundTag nbt) {
        }

        public void postProcess(WorldGenLevel world, StructureManager structureAccessor, ChunkGenerator chunkGenerator, RandomSource random, BoundingBox chunkBox, ChunkPos chunkPos, BlockPos pivot) {
            int maxRoads = (Integer)IafCommonConfig.INSTANCE.pixie.size.getValue() + random.nextInt(5);
            BlockPos buildPosition = pivot;
            for (int placedRoads = 0; placedRoads < maxRoads; ++placedRoads) {
                int roadLength = 10 + random.nextInt(15);
                Direction buildingDirection = Direction.from2DDataValue((int)random.nextInt(3));
                for (int i = 0; i < roadLength; ++i) {
                    BlockPos buildPosition2 = buildPosition.relative(buildingDirection, i);
                    if (world.getBlockState(buildPosition2 = world.getHeightmapPos(Heightmap.Types.WORLD_SURFACE_WG, buildPosition2).below()).getFluidState().isEmpty()) {
                        world.setBlock(buildPosition2, Blocks.DIRT_PATH.defaultBlockState(), 2);
                    } else {
                        world.setBlock(buildPosition2, Blocks.SPRUCE_PLANKS.defaultBlockState(), 2);
                    }
                    if (random.nextInt(8) != 0) continue;
                    Direction houseDir = random.nextBoolean() ? buildingDirection.getClockWise() : buildingDirection.getCounterClockWise();
                    int houseColor = random.nextInt(5);
                    BlockState houseState = switch (houseColor) {
                        case 0 -> (BlockState)((Block)IafBlocks.PIXIE_HOUSE_MUSHROOM_RED.get()).defaultBlockState().setValue((Property)BlockPixieHouse.FACING, (Comparable)houseDir.getOpposite());
                        case 1 -> (BlockState)((Block)IafBlocks.PIXIE_HOUSE_MUSHROOM_BROWN.get()).defaultBlockState().setValue((Property)BlockPixieHouse.FACING, (Comparable)houseDir.getOpposite());
                        case 2 -> (BlockState)((Block)IafBlocks.PIXIE_HOUSE_OAK.get()).defaultBlockState().setValue((Property)BlockPixieHouse.FACING, (Comparable)houseDir.getOpposite());
                        case 3 -> (BlockState)((Block)IafBlocks.PIXIE_HOUSE_BIRCH.get()).defaultBlockState().setValue((Property)BlockPixieHouse.FACING, (Comparable)houseDir.getOpposite());
                        case 4 -> (BlockState)((Block)IafBlocks.PIXIE_HOUSE_SPRUCE.get()).defaultBlockState().setValue((Property)BlockPixieHouse.FACING, (Comparable)houseDir.getOpposite());
                        case 5 -> (BlockState)((Block)IafBlocks.PIXIE_HOUSE_DARK_OAK.get()).defaultBlockState().setValue((Property)BlockPixieHouse.FACING, (Comparable)houseDir.getOpposite());
                        default -> ((Block)IafBlocks.PIXIE_HOUSE_OAK.get()).defaultBlockState();
                    };
                    EntityPixie pixie = (EntityPixie)((EntityType)IafEntities.PIXIE.get()).create((Level)world.getLevel());
                    assert (pixie != null);
                    pixie.finalizeSpawn((ServerLevelAccessor)world, world.getCurrentDifficultyAt(buildPosition2.above()), MobSpawnType.SPAWNER, null);
                    pixie.setPos(buildPosition2.getX(), buildPosition2.getY() + 2, buildPosition2.getZ());
                    pixie.setPersistenceRequired();
                    world.addFreshEntity((Entity)pixie);
                    world.setBlock(buildPosition2.relative(houseDir).above(), houseState, 2);
                    if (world.getBlockState(buildPosition2.relative(houseDir)).canOcclude()) continue;
                    world.setBlock(buildPosition2.relative(houseDir), Blocks.COARSE_DIRT.defaultBlockState(), 2);
                    world.setBlock(buildPosition2.relative(houseDir).below(), Blocks.COARSE_DIRT.defaultBlockState(), 2);
                }
                buildPosition = buildPosition.relative(buildingDirection, random.nextInt(roadLength));
            }
        }
    }
}

