/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.screen.gui;

import com.iafenvoy.iceandfire.entity.EntityDragonBase;
import com.iafenvoy.iceandfire.screen.handler.DragonScreenHandler;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class DragonScreen
extends AbstractContainerScreen<DragonScreenHandler> {
    private static final ResourceLocation texture = ResourceLocation.fromNamespaceAndPath((String)"iceandfire", (String)"textures/gui/dragon.png");

    public DragonScreen(DragonScreenHandler dragonInv, Inventory playerInv, Component name) {
        super((AbstractContainerMenu)dragonInv, playerInv, name);
        this.imageHeight = 214;
    }

    protected void renderLabels(GuiGraphics matrixStack, int mouseX, int mouseY) {
    }

    public void render(GuiGraphics matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(matrixStack, mouseX, mouseY, partialTicks);
        super.render(matrixStack, mouseX, mouseY, partialTicks);
        this.renderTooltip(matrixStack, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics matrixStack, float partialTicks, int mouseX, int mouseY) {
        EntityDragonBase dragon;
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int k = (this.width - this.imageWidth) / 2;
        int l = (this.height - this.imageHeight) / 2;
        matrixStack.blit(texture, k, l, 0, 0, this.imageWidth, this.imageHeight);
        assert (Minecraft.getInstance().level != null);
        Entity entity = Minecraft.getInstance().level.getEntity(((DragonScreenHandler)this.menu).getDragonId());
        if (entity instanceof EntityDragonBase) {
            dragon = (EntityDragonBase)entity;
            float dragonScale = 1.0f / Math.max(1.0E-4f, dragon.getAgeScale());
            Quaternionf quaternionf = new Quaternionf().rotateY((float)Mth.lerp((double)((float)mouseX / (float)this.width), (double)0.0, (double)Math.PI)).rotateZ((float)Mth.lerp((double)((float)mouseY / (float)this.width), (double)Math.PI, (double)3.3415926535897933));
            InventoryScreen.renderEntityInInventory((GuiGraphics)matrixStack, (float)(k + 88), (float)(l + (int)(0.5f * dragon.flyProgress) + 55), (float)((int)(dragonScale * 23.0f)), (Vector3f)new Vector3f(0.0f), (Quaternionf)quaternionf, null, (LivingEntity)dragon);
        }
        if (entity instanceof EntityDragonBase) {
            dragon = (EntityDragonBase)entity;
            assert (this.minecraft != null);
            Font textRenderer = this.minecraft.font;
            String s3 = dragon.getCustomName() == null ? I18n.get((String)"dragon.unnamed", (Object[])new Object[0]) : I18n.get((String)"dragon.name", (Object[])new Object[0]) + " " + dragon.getCustomName().getString();
            textRenderer.drawInBatch(s3, (float)k + (float)this.imageWidth / 2.0f - (float)textRenderer.width(s3) / 2.0f, (float)(l + 75), 0xFFFFFF, false, matrixStack.pose().last().pose(), (MultiBufferSource)matrixStack.bufferSource(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
            String s2 = I18n.get((String)"dragon.health", (Object[])new Object[0]) + " " + Math.floor(Math.min(dragon.getHealth(), dragon.getMaxHealth())) + " / " + dragon.getMaxHealth();
            textRenderer.drawInBatch(s2, (float)k + (float)this.imageWidth / 2.0f - (float)textRenderer.width(s2) / 2.0f, (float)(l + 84), 0xFFFFFF, false, matrixStack.pose().last().pose(), (MultiBufferSource)matrixStack.bufferSource(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
            String s = dragon.isMale() ? "dragon.gender.male" : "dragon.gender.female";
            String s5 = I18n.get((String)"dragon.gender", (Object[])new Object[0]) + I18n.get((String)s, (Object[])new Object[0]);
            textRenderer.drawInBatch(s5, (float)k + (float)this.imageWidth / 2.0f - (float)textRenderer.width(s5) / 2.0f, (float)(l + 93), 0xFFFFFF, false, matrixStack.pose().last().pose(), (MultiBufferSource)matrixStack.bufferSource(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
            String s6 = I18n.get((String)"dragon.hunger", (Object[])new Object[0]) + dragon.getHunger() + "/100";
            textRenderer.drawInBatch(s6, (float)k + (float)this.imageWidth / 2.0f - (float)textRenderer.width(s6) / 2.0f, (float)(l + 102), 0xFFFFFF, false, matrixStack.pose().last().pose(), (MultiBufferSource)matrixStack.bufferSource(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
            String s4 = I18n.get((String)"dragon.stage", (Object[])new Object[0]) + " " + dragon.getDragonStage() + " " + I18n.get((String)"dragon.days.front", (Object[])new Object[0]) + dragon.getAgeInDays() + " " + I18n.get((String)"dragon.days.back", (Object[])new Object[0]);
            textRenderer.drawInBatch(s4, (float)k + (float)this.imageWidth / 2.0f - (float)textRenderer.width(s4) / 2.0f, (float)(l + 111), 0xFFFFFF, false, matrixStack.pose().last().pose(), (MultiBufferSource)matrixStack.bufferSource(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
            String s7 = dragon.getOwner() != null ? I18n.get((String)"dragon.owner", (Object[])new Object[0]) + dragon.getOwner().getName().getString() : I18n.get((String)"dragon.untamed", (Object[])new Object[0]);
            textRenderer.drawInBatch(s7, (float)k + (float)this.imageWidth / 2.0f - (float)textRenderer.width(s7) / 2.0f, (float)(l + 120), 0xFFFFFF, false, matrixStack.pose().last().pose(), (MultiBufferSource)matrixStack.bufferSource(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
        }
    }
}

