/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.render.model.util;

import com.iafenvoy.iceandfire.entity.EntityDragonBase;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.VoxelShape;

public class LegSolver {
    public final Leg[] legs;

    public LegSolver(Leg ... legs) {
        this.legs = legs;
    }

    public final void update(EntityDragonBase entity, float scale) {
        this.update(entity, entity.yBodyRot, scale);
    }

    public final void update(EntityDragonBase entity, float yaw, float scale) {
        double sideTheta = (double)yaw / 57.29577951308232;
        double sideX = Mth.cos((float)((float)sideTheta)) * scale;
        double sideZ = Mth.sin((float)((float)sideTheta)) * scale;
        double forwardTheta = sideTheta + 1.5707963267948966;
        double forwardX = Mth.cos((float)((float)forwardTheta)) * scale;
        double forwardZ = Mth.sin((float)((float)forwardTheta)) * scale;
        for (Leg leg : this.legs) {
            leg.update(entity, sideX, sideZ, forwardX, forwardZ, scale);
        }
    }

    public static final class Leg {
        public final float forward;
        public final float side;
        private final float range;
        private float height;
        private float prevHeight;

        public Leg(float forward, float side, float range, boolean isWing) {
            this.forward = forward;
            this.side = side;
            this.range = range;
        }

        public float getHeight(float delta) {
            return this.prevHeight + (this.height - this.prevHeight) * delta;
        }

        public void update(EntityDragonBase entity, double sideX, double sideZ, double forwardX, double forwardZ, float scale) {
            this.prevHeight = this.height;
            double posY = entity.getY();
            float settledHeight = this.settle(entity, entity.getX() + sideX * (double)this.side + forwardX * (double)this.forward, posY, entity.getZ() + sideZ * (double)this.side + forwardZ * (double)this.forward, this.height);
            this.height = Mth.clamp((float)settledHeight, (float)(-this.range * scale), (float)(this.range * scale));
        }

        private float settle(EntityDragonBase entity, double x, double y, double z, float height) {
            BlockPos pos = BlockPos.containing((double)x, (double)(y + 0.001), (double)z);
            float dist = this.getDistance(entity.level(), pos);
            dist = (double)(1.0f - dist) < 0.001 ? this.getDistance(entity.level(), pos.below()) + (float)y % 1.0f : (dist -= (float)(1.0 - y % 1.0));
            if (entity.onGround() && height <= dist) {
                return height == dist ? height : Math.min(height + this.getFallSpeed(), dist);
            }
            if (height > 0.0f) {
                return Math.max(height - this.getRiseSpeed(), dist);
            }
            return height;
        }

        private float getDistance(Level world, BlockPos pos) {
            BlockState state = world.getBlockState(pos);
            VoxelShape aabb = state.getCollisionShape((BlockGetter)world, pos);
            return aabb.isEmpty() ? 1.0f : 1.0f - Math.min((float)aabb.max(Direction.Axis.Y, 0.5, 0.5), 1.0f);
        }

        private float getFallSpeed() {
            return 0.25f;
        }

        private float getRiseSpeed() {
            return 0.25f;
        }
    }
}

