/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.render.model;

import com.iafenvoy.iceandfire.entity.util.IFlapable;
import com.iafenvoy.uranus.client.model.basic.BasicModelPart;
import net.minecraft.client.Minecraft;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;

public class IFChainBuffer {
    private int yawTimer;
    private float yawVariation;
    private int pitchTimer;
    private float pitchVariation;
    private float prevYawVariation;
    private float prevPitchVariation;

    public void resetRotations() {
        this.yawVariation = 0.0f;
        this.pitchVariation = 0.0f;
        this.prevYawVariation = 0.0f;
        this.prevPitchVariation = 0.0f;
    }

    private boolean compareDouble(double a, double b) {
        double c = a - b;
        return Math.abs(c - 1.0) <= 0.01;
    }

    public void calculateChainSwingBuffer(float maxAngle, int bufferTime, float angleDecrement, float divisor, LivingEntity entity) {
        this.prevYawVariation = this.yawVariation;
        if (!this.compareDouble(entity.yBodyRot, entity.yBodyRotO) && Mth.abs((float)this.yawVariation) < maxAngle) {
            this.yawVariation += Mth.clamp((float)((entity.yBodyRotO - entity.yBodyRot) / divisor), (float)(-maxAngle), (float)maxAngle);
        }
        if (this.yawVariation > angleDecrement) {
            if (this.yawTimer > bufferTime) {
                this.yawVariation -= angleDecrement;
                if (Mth.abs((float)this.yawVariation) < angleDecrement) {
                    this.yawVariation = angleDecrement;
                    this.yawTimer = 0;
                }
            } else {
                ++this.yawTimer;
            }
        } else if (this.yawVariation < -1.0f * angleDecrement) {
            if (this.yawTimer > bufferTime) {
                this.yawVariation += angleDecrement;
                if (Mth.abs((float)this.yawVariation) < angleDecrement) {
                    this.yawVariation = angleDecrement;
                    this.yawTimer = 0;
                }
            } else {
                ++this.yawTimer;
            }
        }
    }

    public void calculateChainPitchBuffer(float maxAngle, int bufferTime, float angleDecrement, float divisor, LivingEntity entity) {
        this.prevPitchVariation = entity.xRotO;
        this.pitchVariation = entity.getXRot();
    }

    public void calculateChainWaveBuffer(float maxAngle, int bufferTime, float angleDecrement, float divisor, LivingEntity entity) {
        this.prevPitchVariation = this.pitchVariation;
        if (Math.abs(entity.getXRot()) > maxAngle) {
            return;
        }
        if (!this.compareDouble(entity.getXRot(), entity.xRotO) && Mth.abs((float)this.pitchVariation) < maxAngle) {
            this.pitchVariation += Mth.clamp((float)((entity.xRotO - entity.getXRot()) / divisor), (float)(-maxAngle), (float)maxAngle);
        }
        if (this.pitchVariation > angleDecrement) {
            if (this.pitchTimer > bufferTime) {
                this.pitchVariation -= angleDecrement;
                if (Mth.abs((float)this.pitchVariation) < angleDecrement) {
                    this.pitchVariation = 0.0f;
                    this.pitchTimer = 0;
                }
            } else {
                ++this.pitchTimer;
            }
        } else if (this.pitchVariation < -1.0f * angleDecrement) {
            if (this.pitchTimer > bufferTime) {
                this.pitchVariation += angleDecrement;
                if (Mth.abs((float)this.pitchVariation) < angleDecrement) {
                    this.pitchVariation = 0.0f;
                    this.pitchTimer = 0;
                }
            } else {
                ++this.pitchTimer;
            }
        }
    }

    public void calculateChainFlapBuffer(float maxAngle, int bufferTime, float angleDecrement, float divisor, LivingEntity entity) {
        this.prevYawVariation = this.yawVariation;
        if (!this.compareDouble(entity.yBodyRot, entity.yBodyRotO) && Mth.abs((float)this.yawVariation) < maxAngle) {
            this.yawVariation += Mth.clamp((float)((entity.yBodyRotO - entity.yBodyRot) / divisor), (float)(-maxAngle), (float)maxAngle);
            if (entity instanceof IFlapable) {
                IFlapable flap = (IFlapable)entity;
                if ((double)Math.abs(entity.yBodyRotO - entity.yBodyRot) > 15.0) {
                    flap.flapWings();
                }
            }
        }
        if (this.yawVariation > angleDecrement) {
            if (this.yawTimer > bufferTime) {
                this.yawVariation -= angleDecrement;
                if (Mth.abs((float)this.yawVariation) < angleDecrement) {
                    this.yawVariation = 0.0f;
                    this.yawTimer = 0;
                }
            } else {
                ++this.yawTimer;
            }
        } else if (this.yawVariation < -1.0f * angleDecrement) {
            if (this.yawTimer > bufferTime) {
                this.yawVariation += angleDecrement;
                if (Mth.abs((float)this.yawVariation) < angleDecrement) {
                    this.yawVariation = 0.0f;
                    this.yawTimer = 0;
                }
            } else {
                ++this.yawTimer;
            }
        }
    }

    public void calculateChainFlapBufferHead(float maxAngle, int bufferTime, float angleDecrement, float divisor, LivingEntity entity) {
        this.prevYawVariation = this.yawVariation;
        if (!this.compareDouble(entity.yHeadRotO, entity.yHeadRot) && Mth.abs((float)this.yawVariation) < maxAngle) {
            this.yawVariation += Mth.clamp((float)((entity.yHeadRot - entity.yHeadRotO) / divisor), (float)(-maxAngle), (float)maxAngle);
            if (entity instanceof IFlapable) {
                IFlapable flap = (IFlapable)entity;
                if ((double)Math.abs(entity.yHeadRot - entity.yHeadRotO) > 15.0) {
                    flap.flapWings();
                }
            }
        }
        if (this.yawVariation > angleDecrement) {
            if (this.yawTimer > bufferTime) {
                this.yawVariation -= angleDecrement;
                if (Mth.abs((float)this.yawVariation) < angleDecrement) {
                    this.yawVariation = 0.0f;
                    this.yawTimer = 0;
                }
            } else {
                ++this.yawTimer;
            }
        } else if (this.yawVariation < -1.0f * angleDecrement) {
            if (this.yawTimer > bufferTime) {
                this.yawVariation += angleDecrement;
                if (Mth.abs((float)this.yawVariation) < angleDecrement) {
                    this.yawVariation = 0.0f;
                    this.yawTimer = 0;
                }
            } else {
                ++this.yawTimer;
            }
        }
    }

    public void calculateChainSwingBuffer(float maxAngle, int bufferTime, float angleDecrement, LivingEntity entity) {
        this.calculateChainSwingBuffer(maxAngle, bufferTime, angleDecrement, 1.0f, entity);
    }

    public void calculateChainWaveBuffer(float maxAngle, int bufferTime, float angleDecrement, LivingEntity entity) {
        this.calculateChainWaveBuffer(maxAngle, bufferTime, angleDecrement, 1.0f, entity);
    }

    public void calculateChainFlapBuffer(float maxAngle, int bufferTime, float angleDecrement, LivingEntity entity) {
        this.calculateChainFlapBuffer(maxAngle, bufferTime, angleDecrement, 1.0f, entity);
    }

    public void applyChainSwingBuffer(BasicModelPart ... boxes) {
        float rotateAmount = (float)Math.PI / 180 * Mth.lerp((float)this.getPartialTicks(), (float)this.prevYawVariation, (float)this.yawVariation) / (float)boxes.length;
        for (BasicModelPart box : boxes) {
            box.rotateAngleY += rotateAmount;
        }
    }

    public void applyChainWaveBuffer(BasicModelPart ... boxes) {
        float rotateAmount = (float)Math.PI / 180 * Mth.lerp((float)this.getPartialTicks(), (float)this.prevYawVariation, (float)this.yawVariation) / (float)boxes.length;
        for (BasicModelPart box : boxes) {
            box.rotateAngleX += rotateAmount;
        }
    }

    public void applyChainFlapBuffer(BasicModelPart ... boxes) {
        float rotateAmount = (float)Math.PI / 180 * Mth.lerp((float)this.getPartialTicks(), (float)this.prevYawVariation, (float)this.yawVariation) / (float)boxes.length;
        for (BasicModelPart box : boxes) {
            box.rotateAngleZ += rotateAmount;
        }
    }

    public void applyChainFlapBufferReverse(BasicModelPart ... boxes) {
        float rotateAmount = (float)Math.PI / 180 * Mth.lerp((float)this.getPartialTicks(), (float)this.prevYawVariation, (float)this.yawVariation) / (float)boxes.length;
        for (BasicModelPart box : boxes) {
            box.rotateAngleZ -= rotateAmount * 0.5f;
        }
    }

    public void applyChainSwingBufferReverse(BasicModelPart ... boxes) {
        float rotateAmount = (float)Math.PI / 180 * Mth.lerp((float)this.getPartialTicks(), (float)this.prevYawVariation, (float)this.yawVariation) / (float)boxes.length;
        for (BasicModelPart box : boxes) {
            box.rotateAngleY -= rotateAmount;
        }
    }

    public void applyChainWaveBufferReverse(BasicModelPart ... boxes) {
        float rotateAmount = (float)Math.PI / 180 * Mth.lerp((float)this.getPartialTicks(), (float)this.prevYawVariation, (float)this.yawVariation) / (float)boxes.length;
        for (BasicModelPart box : boxes) {
            box.rotateAngleX -= rotateAmount;
        }
    }

    private float getPartialTicks() {
        return Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(false);
    }
}

