/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.render.entity.layer;

import com.iafenvoy.iceandfire.data.DragonArmorMaterial;
import com.iafenvoy.iceandfire.entity.EntityDragonBase;
import com.iafenvoy.uranus.client.model.TabulaModel;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;

public class LayerDragonArmor
extends RenderLayer<EntityDragonBase, TabulaModel<EntityDragonBase>> {
    private static final List<EquipmentSlot> ARMOR_SLOTS = List.of(EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET);

    public LayerDragonArmor(MobRenderer<EntityDragonBase, TabulaModel<EntityDragonBase>> renderIn) {
        super(renderIn);
    }

    public void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int light, EntityDragonBase dragon, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        EntityModel model = this.getParentModel();
        for (EquipmentSlot slot : ARMOR_SLOTS) {
            ItemStack stack = dragon.getItemBySlot(slot);
            if (stack.isEmpty()) continue;
            ResourceLocation texture = DragonArmorMaterial.getArmorTexture(stack, slot);
            VertexConsumer vertexConsumer = bufferIn.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)texture));
            model.renderToBuffer(matrixStackIn, vertexConsumer, light, OverlayTexture.NO_OVERLAY, -1);
        }
    }
}

