/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.render.entity;

import com.iafenvoy.iceandfire.entity.EntityCockatrice;
import com.iafenvoy.iceandfire.entity.EntityGorgon;
import com.iafenvoy.iceandfire.particle.CockatriceBeamRender;
import com.iafenvoy.iceandfire.render.model.ModelCockatrice;
import com.iafenvoy.iceandfire.render.model.ModelCockatriceChick;
import com.iafenvoy.uranus.client.model.AdvancedEntityModel;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class RenderCockatrice
extends MobRenderer<EntityCockatrice, AdvancedEntityModel<EntityCockatrice>> {
    public static final ResourceLocation TEXTURE_ROOSTER = ResourceLocation.fromNamespaceAndPath((String)"iceandfire", (String)"textures/entity/cockatrice/cockatrice_0.png");
    public static final ResourceLocation TEXTURE_HEN = ResourceLocation.fromNamespaceAndPath((String)"iceandfire", (String)"textures/entity/cockatrice/cockatrice_1.png");
    public static final ResourceLocation TEXTURE_ROOSTER_CHICK = ResourceLocation.fromNamespaceAndPath((String)"iceandfire", (String)"textures/entity/cockatrice/cockatrice_0_chick.png");
    public static final ResourceLocation TEXTURE_HEN_CHICK = ResourceLocation.fromNamespaceAndPath((String)"iceandfire", (String)"textures/entity/cockatrice/cockatrice_1_chick.png");
    public static final ModelCockatrice ADULT_MODEL = new ModelCockatrice();
    public static final ModelCockatriceChick BABY_MODEL = new ModelCockatriceChick();

    public RenderCockatrice(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new ModelCockatrice(), 0.6f);
    }

    private Vec3 getPosition(LivingEntity LivingEntityIn, double p_177110_2_) {
        double d0 = LivingEntityIn.xOld + (LivingEntityIn.getX() - LivingEntityIn.xOld);
        double d1 = p_177110_2_ + LivingEntityIn.yOld + (LivingEntityIn.getY() - LivingEntityIn.yOld);
        double d2 = LivingEntityIn.zOld + (LivingEntityIn.getZ() - LivingEntityIn.zOld);
        return new Vec3(d0, d1, d2);
    }

    public boolean shouldRender(EntityCockatrice livingEntityIn, Frustum camera, double camX, double camY, double camZ) {
        LivingEntity livingentity;
        if (super.shouldRender((Entity)livingEntityIn, camera, camX, camY, camZ)) {
            return true;
        }
        if (livingEntityIn.hasTargetedEntity() && (livingentity = livingEntityIn.getTargetedEntity()) != null) {
            Vec3 Vector3d = this.getPosition(livingentity, (double)livingentity.getBbHeight() * 0.5);
            Vec3 Vector3d1 = this.getPosition((LivingEntity)livingEntityIn, livingEntityIn.getEyeHeight());
            return camera.isVisible(new AABB(Vector3d1.x, Vector3d1.y, Vector3d1.z, Vector3d.x, Vector3d.y, Vector3d.z));
        }
        return false;
    }

    public void render(EntityCockatrice entityIn, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        boolean blindness;
        this.model = entityIn.isBaby() ? BABY_MODEL : ADULT_MODEL;
        super.render((LivingEntity)entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
        LivingEntity livingentity = entityIn.getTargetedEntity();
        boolean bl = blindness = entityIn.hasEffect(MobEffects.BLINDNESS) || livingentity != null && livingentity.hasEffect(MobEffects.BLINDNESS);
        if (!blindness && livingentity != null && EntityGorgon.isEntityLookingAt((LivingEntity)entityIn, livingentity, 0.6f) && EntityGorgon.isEntityLookingAt(livingentity, (LivingEntity)entityIn, 0.6f)) {
            CockatriceBeamRender.render((Entity)entityIn, (Entity)livingentity, matrixStackIn, bufferIn, partialTicks);
        }
    }

    protected void scale(EntityCockatrice entity, PoseStack matrixStackIn, float partialTickTime) {
        if (entity.isBaby()) {
            matrixStackIn.scale(0.5f, 0.5f, 0.5f);
        }
    }

    public ResourceLocation getTexture(EntityCockatrice cockatrice) {
        return cockatrice.isBaby() ? (cockatrice.isHen() ? TEXTURE_HEN_CHICK : TEXTURE_ROOSTER_CHICK) : (cockatrice.isHen() ? TEXTURE_HEN : TEXTURE_ROOSTER);
    }
}

