/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.mixin;

import com.iafenvoy.iceandfire.event.ClientEvents;
import com.iafenvoy.iceandfire.item.ability.impl.AbilityImpls;
import com.iafenvoy.iceandfire.registry.tag.IafItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin {
    @Shadow
    public abstract ItemStack getItemInHand(InteractionHand var1);

    @Inject(method={"tick()V"}, at={@At(value="RETURN")})
    @OnlyIn(value=Dist.CLIENT)
    private void onEntityTick(CallbackInfo ci) {
        ClientEvents.onLivingUpdate((LivingEntity)this);
    }

    @Inject(method={"swing(Lnet/minecraft/world/InteractionHand;Z)V"}, at={@At(value="HEAD")})
    private void onSwingHand(InteractionHand hand, boolean fromServerPlayer, CallbackInfo ci) {
        ItemStack stack = this.getItemInHand(hand);
        Item item = stack.getItem();
        LivingEntity self = (LivingEntity)this;
        if (stack.is(IafItemTags.SUMMON_GHOST_SWORD) && AbilityImpls.SUMMON_GHOST_SWORD.isEnable()) {
            AbilityImpls.SUMMON_GHOST_SWORD.active(self);
        }
    }
}

