/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.item.block;

import com.iafenvoy.iceandfire.entity.block.BlockEntityEggInIce;
import com.iafenvoy.iceandfire.registry.IafBlockEntities;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;

public class BlockEggInIce
extends BaseEntityBlock {
    private static final MapCodec<? extends BaseEntityBlock> CODEC = BlockEggInIce.simpleCodec(s -> new BlockEggInIce());

    public BlockEggInIce() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.ICE).noOcclusion().dynamicShape().strength(0.5f).dynamicShape().sound(SoundType.GLASS));
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new BlockEntityEggInIce(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> entityType) {
        return BlockEggInIce.createTickerHelper(entityType, (BlockEntityType)((BlockEntityType)IafBlockEntities.EGG_IN_ICE.get()), BlockEntityEggInIce::tickEgg);
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public void playerDestroy(Level world, Player player, BlockPos pos, BlockState state, BlockEntity te, ItemStack stack) {
        player.awardStat(Stats.BLOCK_MINED.get((Object)this));
        player.causeFoodExhaustion(0.005f);
    }

    public BlockState playerWillDestroy(Level world, BlockPos pos, BlockState state, Player player) {
        BlockEntity blockEntity;
        if (world.getBlockEntity(pos) != null && (blockEntity = world.getBlockEntity(pos)) instanceof BlockEntityEggInIce) {
            BlockEntityEggInIce tile = (BlockEntityEggInIce)blockEntity;
            tile.spawnEgg();
        }
        return state;
    }
}

