/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.item;

import com.iafenvoy.iceandfire.entity.EntityPixieCharge;
import com.iafenvoy.iceandfire.registry.IafEntities;
import com.iafenvoy.iceandfire.registry.IafItems;
import com.iafenvoy.iceandfire.registry.IafSounds;
import com.iafenvoy.uranus.object.RegistryHelper;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Fireball;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;

public class ItemPixieWand
extends Item {
    public ItemPixieWand() {
        super(new Item.Properties().stacksTo(1).durability(500));
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        ItemStack itemStackIn = user.getItemInHand(hand);
        boolean flag = user.isCreative() || EnchantmentHelper.getItemEnchantmentLevel((Holder)RegistryHelper.getEnchantment((RegistryAccess)user.registryAccess(), (ResourceKey)Enchantments.INFINITY), (ItemStack)itemStackIn) > 0;
        ItemStack itemstack = this.findAmmo(user);
        user.startUsingItem(hand);
        user.swing(hand);
        if (!itemstack.isEmpty() || flag) {
            boolean flag1;
            boolean bl = flag1 = user.isCreative() || this.isInfinite(itemstack, itemStackIn, user);
            if (!flag1) {
                itemstack.shrink(1);
                if (itemstack.isEmpty()) {
                    user.getInventory().removeItem(itemstack);
                }
            }
            double d2 = user.getLookAngle().x;
            double d3 = user.getLookAngle().y;
            double d4 = user.getLookAngle().z;
            float inaccuracy = 1.0f;
            EntityPixieCharge charge = new EntityPixieCharge((EntityType<? extends Fireball>)((EntityType)IafEntities.PIXIE_CHARGE.get()), world, user, d2 += user.getRandom().nextGaussian() * (double)0.0075f * (double)inaccuracy, d3 += user.getRandom().nextGaussian() * (double)0.0075f * (double)inaccuracy, d4 += user.getRandom().nextGaussian() * (double)0.0075f * (double)inaccuracy);
            charge.setPos(user.getX(), user.getY() + 1.0, user.getZ());
            if (!world.isClientSide) {
                world.addFreshEntity((Entity)charge);
            }
            user.playSound((SoundEvent)IafSounds.PIXIE_WAND.get(), 1.0f, 0.75f + 0.5f * user.getRandom().nextFloat());
            itemstack.hurtAndBreak(1, (LivingEntity)user, LivingEntity.getSlotForHand((InteractionHand)user.getUsedItemHand()));
            user.getCooldowns().addCooldown((Item)this, 5);
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)itemStackIn);
    }

    public boolean isInfinite(ItemStack stack, ItemStack bow, Player player) {
        int enchant = EnchantmentHelper.getItemEnchantmentLevel((Holder)RegistryHelper.getEnchantment((RegistryAccess)player.registryAccess(), (ResourceKey)Enchantments.INFINITY), (ItemStack)bow);
        return enchant > 0 && stack.getItem() == IafItems.PIXIE_DUST.get();
    }

    private ItemStack findAmmo(Player player) {
        if (this.isAmmo(player.getItemInHand(InteractionHand.OFF_HAND))) {
            return player.getItemInHand(InteractionHand.OFF_HAND);
        }
        if (this.isAmmo(player.getItemInHand(InteractionHand.MAIN_HAND))) {
            return player.getItemInHand(InteractionHand.MAIN_HAND);
        }
        for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
            ItemStack itemstack = player.getInventory().getItem(i);
            if (!this.isAmmo(itemstack)) continue;
            return itemstack;
        }
        return ItemStack.EMPTY;
    }

    protected boolean isAmmo(ItemStack stack) {
        return !stack.isEmpty() && stack.getItem() == IafItems.PIXIE_DUST.get();
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        super.appendHoverText(stack, context, tooltip, type);
        tooltip.add((Component)Component.translatable((String)"item.iceandfire.legendary_weapon.desc").withStyle(ChatFormatting.GRAY));
        tooltip.add((Component)Component.translatable((String)"item.iceandfire.pixie_wand.desc_0").withStyle(ChatFormatting.GRAY));
        tooltip.add((Component)Component.translatable((String)"item.iceandfire.pixie_wand.desc_1").withStyle(ChatFormatting.GRAY));
    }
}

