/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.event;

import com.iafenvoy.iceandfire.config.IafClientConfig;
import com.iafenvoy.iceandfire.data.component.IafEntityData;
import com.iafenvoy.iceandfire.entity.EntityDragonBase;
import com.iafenvoy.iceandfire.entity.EntityMultipartPart;
import com.iafenvoy.iceandfire.entity.util.ICustomMoveController;
import com.iafenvoy.iceandfire.network.payload.DragonControlPayload;
import com.iafenvoy.iceandfire.particle.CockatriceBeamRender;
import com.iafenvoy.iceandfire.registry.IafKeybindings;
import com.iafenvoy.iceandfire.registry.IafParticles;
import com.iafenvoy.iceandfire.render.block.RenderFrozenState;
import com.iafenvoy.iceandfire.render.entity.RenderChain;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.architectury.event.EventResult;
import dev.architectury.networking.NetworkManager;
import net.minecraft.client.Camera;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ClientEvents {
    private static final ResourceLocation SIREN_SHADER = ResourceLocation.fromNamespaceAndPath((String)"iceandfire", (String)"shaders/post/siren.json");
    public static int currentView = 0;

    public static void onCameraSetup(Camera camera) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null && player.getVehicle() instanceof EntityDragonBase) {
            float scale = ((EntityDragonBase)player.getVehicle()).getRenderSize() / 3.0f;
            if (Minecraft.getInstance().options.getCameraType() == CameraType.THIRD_PERSON_BACK || Minecraft.getInstance().options.getCameraType() == CameraType.THIRD_PERSON_FRONT) {
                if (currentView == 1) {
                    camera.move(-camera.getMaxZoom(scale * 1.2f), 0.0f, 0.0f);
                } else if (currentView == 2) {
                    camera.move(-camera.getMaxZoom(scale * 3.0f), 0.0f, 0.0f);
                } else if (currentView == 3) {
                    camera.move(-camera.getMaxZoom(scale * 5.0f), 0.0f, 0.0f);
                }
            }
        }
    }

    public static EventResult onEntityInteract(Player player, Entity entity, InteractionHand hand) {
        if (entity instanceof EntityMultipartPart) {
            return EventResult.interruptTrue();
        }
        return EventResult.pass();
    }

    public static void onLivingUpdate(LivingEntity entity) {
        Minecraft mc = Minecraft.getInstance();
        if (entity instanceof ICustomMoveController) {
            ICustomMoveController moveController = (ICustomMoveController)entity;
            if (entity.getVehicle() != null && entity.getVehicle() == mc.player) {
                byte previousState = moveController.getControlState();
                moveController.dismount(mc.options.keyShift.isDown());
                byte controlState = moveController.getControlState();
                if (controlState != previousState) {
                    NetworkManager.sendToServer((CustomPacketPayload)new DragonControlPayload(entity.getId(), controlState, entity.blockPosition()));
                }
            }
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (player.level().isClientSide) {
                Entity controlState = player.getVehicle();
                if (controlState instanceof ICustomMoveController) {
                    ICustomMoveController controller = (ICustomMoveController)controlState;
                    Entity vehicle = player.getVehicle();
                    byte previousState = controller.getControlState();
                    controller.up(mc.options.keyJump.isDown());
                    controller.down(IafKeybindings.DRAGON_DOWN.isDown());
                    controller.attack(IafKeybindings.DRAGON_STRIKE.isDown());
                    controller.dismount(mc.options.keyShift.isDown());
                    controller.strike(IafKeybindings.DRAGON_BREATH.isDown());
                    byte controlState2 = controller.getControlState();
                    if (controlState2 != previousState) {
                        NetworkManager.sendToServer((CustomPacketPayload)new DragonControlPayload(vehicle.getId(), controlState2, vehicle.blockPosition()));
                    }
                }
                GameRenderer renderer = Minecraft.getInstance().gameRenderer;
                IafEntityData data = IafEntityData.get((LivingEntity)player);
                if (((Boolean)IafClientConfig.INSTANCE.sirenShader.getValue()).booleanValue() && data.sirenData.charmedBy == null && renderer.currentEffect() != null && SIREN_SHADER.toString().equals(renderer.currentEffect().getName())) {
                    renderer.shutdownEffect();
                }
                if (data.sirenData.charmedBy == null) {
                    return;
                }
                if (((Boolean)IafClientConfig.INSTANCE.sirenShader.getValue()).booleanValue() && !data.sirenData.isCharmed && renderer.currentEffect() != null && SIREN_SHADER.toString().equals(renderer.currentEffect().getName())) {
                    renderer.shutdownEffect();
                }
                if (data.sirenData.isCharmed) {
                    if (entity.getRandom().nextInt(40) == 0) {
                        entity.level().addParticle((ParticleOptions)IafParticles.SIREN_APPEARANCE.get(), player.getX(), player.getY(), player.getZ(), (double)data.sirenData.charmedBy.getHairColor(), 0.0, 0.0);
                    }
                    if (((Boolean)IafClientConfig.INSTANCE.sirenShader.getValue()).booleanValue() && renderer.currentEffect() == null) {
                        renderer.loadEffect(SIREN_SHADER);
                    }
                }
            }
        }
    }

    public static void onPostRenderLiving(LivingEntity entity, float partialRenderTick, PoseStack matrixStack, MultiBufferSource buffers, int light) {
        IafEntityData data = IafEntityData.get(entity);
        data.miscData.checkScepterTarget();
        for (LivingEntity target : data.miscData.getTargetedByScepter()) {
            CockatriceBeamRender.render((Entity)entity, (Entity)target, matrixStack, buffers, partialRenderTick);
        }
        if (data.frozenData.isFrozen) {
            RenderFrozenState.render(entity, matrixStack, buffers, light, data.frozenData.frozenTicks);
        }
        RenderChain.render(entity, matrixStack, buffers, light, data.chainData.getChainedTo());
    }
}

