/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.entity.block;

import com.iafenvoy.iceandfire.entity.EntityPixie;
import com.iafenvoy.iceandfire.network.payload.UpdatePixieHousePayload;
import com.iafenvoy.iceandfire.network.payload.UpdatePixieJarPayload;
import com.iafenvoy.iceandfire.registry.IafBlockEntities;
import com.iafenvoy.iceandfire.registry.IafEntities;
import com.iafenvoy.iceandfire.registry.IafParticles;
import com.iafenvoy.iceandfire.registry.IafSounds;
import com.iafenvoy.uranus.ServerHelper;
import java.util.Random;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class BlockEntityJar
extends BlockEntity {
    private static final float PARTICLE_WIDTH = 0.3f;
    private static final float PARTICLE_HEIGHT = 0.6f;
    private final Random rand;
    public boolean hasPixie;
    public boolean prevHasProduced;
    public boolean hasProduced;
    public boolean tamedPixie;
    public UUID pixieOwnerUUID;
    public int pixieType;
    public int ticksExisted;
    public NonNullList<ItemStack> pixieItems = NonNullList.withSize((int)1, (Object)ItemStack.EMPTY);
    public float rotationYaw;
    public float prevRotationYaw;

    public BlockEntityJar(BlockPos pos, BlockState state) {
        super((BlockEntityType)IafBlockEntities.PIXIE_JAR.get(), pos, state);
        this.rand = new Random();
        this.hasPixie = true;
    }

    public BlockEntityJar(BlockPos pos, BlockState state, boolean empty) {
        super((BlockEntityType)IafBlockEntities.PIXIE_JAR.get(), pos, state);
        this.rand = new Random();
        this.hasPixie = !empty;
    }

    public static void tick(Level level, BlockPos pos, BlockState state, BlockEntityJar entityJar) {
        ++entityJar.ticksExisted;
        if (level.isClientSide && entityJar.hasPixie) {
            level.addParticle((ParticleOptions)IafParticles.PIXIE_DUST.get(), (double)((float)pos.getX() + 0.5f) + (double)(entityJar.rand.nextFloat() * 0.3f * 2.0f) - (double)0.3f, (double)pos.getY() + (double)(entityJar.rand.nextFloat() * 0.6f), (double)((float)pos.getZ() + 0.5f) + (double)(entityJar.rand.nextFloat() * 0.3f * 2.0f) - (double)0.3f, (double)EntityPixie.PARTICLE_RGB[entityJar.pixieType][0], (double)EntityPixie.PARTICLE_RGB[entityJar.pixieType][1], (double)EntityPixie.PARTICLE_RGB[entityJar.pixieType][2]);
        }
        if (entityJar.ticksExisted % 24000 == 0 && !entityJar.hasProduced && entityJar.hasPixie) {
            entityJar.hasProduced = true;
            if (!level.isClientSide) {
                ServerHelper.sendToAll((CustomPacketPayload)new UpdatePixieJarPayload(pos, true));
            }
        }
        if (entityJar.hasPixie && entityJar.hasProduced != entityJar.prevHasProduced && entityJar.ticksExisted > 5) {
            if (!level.isClientSide) {
                ServerHelper.sendToAll((CustomPacketPayload)new UpdatePixieJarPayload(pos, entityJar.hasProduced));
            } else {
                level.playLocalSound((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, (SoundEvent)IafSounds.PIXIE_HURT.get(), SoundSource.BLOCKS, 1.0f, 1.0f, false);
            }
        }
        entityJar.prevRotationYaw = entityJar.rotationYaw;
        if (entityJar.rand.nextInt(30) == 0) {
            entityJar.rotationYaw = entityJar.rand.nextFloat() * 360.0f - 180.0f;
        }
        if (entityJar.hasPixie && entityJar.ticksExisted % 40 == 0 && entityJar.rand.nextInt(6) == 0 && level.isClientSide) {
            level.playLocalSound((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, (SoundEvent)IafSounds.PIXIE_IDLE.get(), SoundSource.BLOCKS, 1.0f, 1.0f, false);
        }
        entityJar.prevHasProduced = entityJar.hasProduced;
    }

    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.saveAdditional(nbt, registryLookup);
        nbt.putBoolean("HasPixie", this.hasPixie);
        nbt.putInt("PixieType", this.pixieType);
        nbt.putBoolean("HasProduced", this.hasProduced);
        nbt.putBoolean("TamedPixie", this.tamedPixie);
        if (this.pixieOwnerUUID != null) {
            nbt.putUUID("PixieOwnerUUID", this.pixieOwnerUUID);
        }
        nbt.putInt("TicksExisted", this.ticksExisted);
        ContainerHelper.saveAllItems((CompoundTag)nbt, this.pixieItems, (HolderLookup.Provider)registryLookup);
    }

    public ClientboundBlockEntityDataPacket toUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.loadAdditional(nbt, registryLookup);
        this.hasPixie = nbt.getBoolean("HasPixie");
        this.pixieType = nbt.getInt("PixieType");
        this.hasProduced = nbt.getBoolean("HasProduced");
        this.ticksExisted = nbt.getInt("TicksExisted");
        this.tamedPixie = nbt.getBoolean("TamedPixie");
        if (nbt.hasUUID("PixieOwnerUUID")) {
            this.pixieOwnerUUID = nbt.getUUID("PixieOwnerUUID");
        }
        this.pixieItems = NonNullList.withSize((int)1, (Object)ItemStack.EMPTY);
        ContainerHelper.loadAllItems((CompoundTag)nbt, this.pixieItems, (HolderLookup.Provider)registryLookup);
    }

    public void releasePixie() {
        EntityPixie pixie = new EntityPixie((EntityType<? extends EntityPixie>)((EntityType)IafEntities.PIXIE.get()), this.level);
        pixie.absMoveTo((float)this.worldPosition.getX() + 0.5f, (float)this.worldPosition.getY() + 1.0f, (float)this.worldPosition.getZ() + 0.5f, new Random().nextInt(360), 0.0f);
        pixie.setItemInHand(InteractionHand.MAIN_HAND, (ItemStack)this.pixieItems.getFirst());
        pixie.setColor(this.pixieType);
        pixie.ticksUntilHouseAI = 500;
        pixie.setTame(this.tamedPixie, false);
        pixie.setOwnerUUID(this.pixieOwnerUUID);
        assert (this.level != null);
        this.level.addFreshEntity((Entity)pixie);
        this.hasPixie = false;
        this.pixieType = 0;
        if (!this.level.isClientSide) {
            ServerHelper.sendToAll((CustomPacketPayload)new UpdatePixieHousePayload(this.worldPosition, false, 0));
        }
    }
}

