/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.entity.block;

import com.iafenvoy.iceandfire.entity.EntityGhost;
import com.iafenvoy.iceandfire.registry.IafBlockEntities;
import com.iafenvoy.iceandfire.registry.IafEntities;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class BlockEntityGhostChest
extends ChestBlockEntity {
    public BlockEntityGhostChest(BlockPos pos, BlockState state) {
        super((BlockEntityType)IafBlockEntities.GHOST_CHEST.get(), pos, state);
    }

    public void startOpen(Player player) {
        super.startOpen(player);
        assert (this.level != null);
        if (this.level.getDifficulty() != Difficulty.PEACEFUL) {
            EntityGhost ghost = (EntityGhost)((EntityType)IafEntities.GHOST.get()).create(this.level);
            assert (ghost != null);
            ghost.absMoveTo((float)this.worldPosition.getX() + 0.5f, (float)this.worldPosition.getY() + 0.5f, (float)this.worldPosition.getZ() + 0.5f, ThreadLocalRandom.current().nextFloat() * 360.0f, 0.0f);
            Level level = this.level;
            if (level instanceof ServerLevel) {
                ServerLevel serverWorld = (ServerLevel)level;
                ghost.finalizeSpawn((ServerLevelAccessor)serverWorld, this.level.getCurrentDifficultyAt(this.worldPosition), MobSpawnType.SPAWNER, null);
                if (!player.isCreative()) {
                    ghost.setTarget((LivingEntity)player);
                }
                ghost.setPersistenceRequired();
                this.level.addFreshEntity((Entity)ghost);
            }
            ghost.setAnimation(EntityGhost.ANIMATION_SCARE);
            ghost.restrictTo(this.worldPosition, 4);
            ghost.setFromChest(true);
        }
    }

    protected void signalOpenCount(Level level, BlockPos pos, BlockState state, int p_155336_, int p_155337_) {
        super.signalOpenCount(level, pos, state, p_155336_, p_155337_);
        level.updateNeighborsAt(pos.below(), state.getBlock());
    }
}

