/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.entity.ai;

import com.iafenvoy.iceandfire.entity.EntityDeathWorm;
import com.iafenvoy.iceandfire.entity.util.IGroundMount;
import java.util.EnumSet;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public class EntityGroundAIRide<T extends Mob>
extends Goal {
    private final T dragon;
    private Player player;

    public EntityGroundAIRide(T dragon) {
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        this.dragon = dragon;
    }

    public boolean canUse() {
        this.player = ((IGroundMount)this.dragon).getRidingPlayer();
        return this.player != null;
    }

    public void start() {
        this.dragon.getNavigation().stop();
    }

    public void tick() {
        this.dragon.getNavigation().stop();
        this.dragon.setTarget(null);
        double x = this.dragon.getX();
        double y = this.dragon.getY();
        T t = this.dragon;
        if (t instanceof EntityDeathWorm) {
            EntityDeathWorm worm = (EntityDeathWorm)t;
            y = worm.processRiderY(y);
        }
        double z = this.dragon.getZ();
        double speed = (double)1.8f * ((IGroundMount)this.dragon).getRideSpeedModifier();
        if (this.player.xxa != 0.0f || this.player.zza != 0.0f) {
            Vec3 lookVec = this.player.getLookAngle();
            if (this.player.zza < 0.0f) {
                lookVec = lookVec.yRot((float)Math.PI);
            } else if (this.player.xxa > 0.0f) {
                lookVec = lookVec.yRot(1.5707964f);
            } else if (this.player.xxa < 0.0f) {
                lookVec = lookVec.yRot(-1.5707964f);
            }
            if ((double)Math.abs(this.player.xxa) > 0.0) {
                speed *= 0.25;
            }
            if ((double)this.player.zza < 0.0) {
                speed *= 0.15;
            }
            x += lookVec.x * 10.0;
            z += lookVec.z * 10.0;
        }
        this.dragon.getMoveControl().setWantedPosition(x, y, z, speed);
    }
}

