/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.entity.ai;

import com.iafenvoy.iceandfire.entity.EntityDeathWorm;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class DeathWormAIGetInSand
extends Goal {
    private final EntityDeathWorm creature;
    private final double movementSpeed;
    private final Level world;
    private double shelterX;
    private double shelterY;
    private double shelterZ;

    public DeathWormAIGetInSand(EntityDeathWorm theCreatureIn, double movementSpeedIn) {
        this.creature = theCreatureIn;
        this.movementSpeed = movementSpeedIn;
        this.world = theCreatureIn.level();
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean canUse() {
        if (this.creature.isVehicle() || this.creature.isInSand() || this.creature.getTarget() != null && !this.creature.getTarget().isInWater() || this.creature.targetItemsGoal.targetEntity != null) {
            return false;
        }
        Vec3 Vector3d = this.findPossibleShelter();
        if (Vector3d == null) {
            return false;
        }
        this.shelterX = Vector3d.x;
        this.shelterY = Vector3d.y;
        this.shelterZ = Vector3d.z;
        return true;
    }

    public boolean canContinueToUse() {
        return !this.creature.getNavigation().isDone();
    }

    public void start() {
        this.creature.getNavigation().moveTo(this.shelterX, this.shelterY, this.shelterZ, this.movementSpeed);
    }

    private Vec3 findPossibleShelter() {
        RandomSource random = this.creature.getRandom();
        BlockPos blockpos = BlockPos.containing((double)this.creature.getBlockX(), (double)this.creature.getBoundingBox().minY, (double)this.creature.getBlockZ());
        for (int i = 0; i < 10; ++i) {
            BlockPos blockpos1 = blockpos.offset(random.nextInt(20) - 10, random.nextInt(6) - 3, random.nextInt(20) - 10);
            if (!this.world.getBlockState(blockpos1).is(BlockTags.SAND)) continue;
            return new Vec3((double)blockpos1.getX(), (double)blockpos1.getY(), (double)blockpos1.getZ());
        }
        return null;
    }
}

