/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.entity.ai;

import com.iafenvoy.iceandfire.entity.EntityDeathWorm;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.pathfinder.Path;

public class DeathWormAIFindSandTarget
extends Goal {
    private final EntityDeathWorm mob;
    private int range;

    public DeathWormAIFindSandTarget(EntityDeathWorm mob, int range) {
        this.mob = mob;
        this.range = range;
    }

    public boolean canUse() {
        if (this.mob.getTarget() != null) {
            return false;
        }
        if (!this.mob.isInSand() || this.mob.isPassenger() || this.mob.isVehicle()) {
            return false;
        }
        if (this.mob.getRandom().nextFloat() < 0.5f) {
            BlockPos vec3;
            Path path = this.mob.getNavigation().getPath();
            if (path != null) {
                this.mob.getNavigation().stop();
            }
            if (this.mob.getNavigation().isDone() && (vec3 = this.findSandTarget()) != null) {
                this.mob.getMoveControl().setWantedPosition((double)vec3.getX(), (double)vec3.getY(), (double)vec3.getZ(), 1.0);
                return true;
            }
        }
        return false;
    }

    public boolean canContinueToUse() {
        return false;
    }

    public BlockPos findSandTarget() {
        if (this.mob.getTarget() == null || !this.mob.getTarget().isAlive()) {
            ArrayList<BlockPos> sand = new ArrayList<BlockPos>();
            if (this.mob.isTame() && this.mob.getWormHome() != null) {
                this.range = 25;
                for (int x = this.mob.getWormHome().getX() - this.range; x < this.mob.getWormHome().getX() + this.range; ++x) {
                    for (int y = this.mob.getWormHome().getY() - this.range; y < this.mob.getWormHome().getY() + this.range; ++y) {
                        for (int z = this.mob.getWormHome().getZ() - this.range; z < this.mob.getWormHome().getZ() + this.range; ++z) {
                            if (!this.mob.level().getBlockState(new BlockPos(x, y, z)).is(BlockTags.SAND)) continue;
                            this.mob.position();
                            sand.add(new BlockPos(x, y, z));
                        }
                    }
                }
            } else {
                for (int x = (int)this.mob.getX() - this.range; x < (int)this.mob.getX() + this.range; ++x) {
                    for (int y = (int)this.mob.getY() - this.range; y < (int)this.mob.getY() + this.range; ++y) {
                        for (int z = (int)this.mob.getZ() - this.range; z < (int)this.mob.getZ() + this.range; ++z) {
                            if (!this.mob.level().getBlockState(new BlockPos(x, y, z)).is(BlockTags.SAND)) continue;
                            this.mob.position();
                            sand.add(new BlockPos(x, y, z));
                        }
                    }
                }
            }
            if (!sand.isEmpty()) {
                return (BlockPos)sand.get(this.mob.getRandom().nextInt(sand.size()));
            }
        } else {
            BlockPos blockpos1 = this.mob.getTarget().blockPosition();
            return new BlockPos(blockpos1.getX(), blockpos1.getY() - 1, blockpos1.getZ());
        }
        return null;
    }
}

