/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.entity.ai;

import com.iafenvoy.iceandfire.entity.EntityAmphithere;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathType;

public class AmphithereAIFollowOwner
extends Goal {
    final Level world;
    final float maxDist;
    final float minDist;
    private final EntityAmphithere ampithere;
    private final double followSpeed;
    private LivingEntity owner;
    private int timeToRecalcPath;
    private float oldWaterCost;

    public AmphithereAIFollowOwner(EntityAmphithere ampithereIn, double followSpeedIn, float minDistIn, float maxDistIn) {
        this.ampithere = ampithereIn;
        this.world = ampithereIn.level();
        this.followSpeed = followSpeedIn;
        this.minDist = minDistIn;
        this.maxDist = maxDistIn;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean canUse() {
        LivingEntity LivingEntity2 = this.ampithere.getOwner();
        if (this.ampithere.getCommand() != 2) {
            return false;
        }
        if (LivingEntity2 == null) {
            return false;
        }
        if (LivingEntity2 instanceof Player && LivingEntity2.isSpectator()) {
            return false;
        }
        if (this.ampithere.isOrderedToSit()) {
            return false;
        }
        if (this.ampithere.distanceToSqr((Entity)LivingEntity2) < (double)(this.minDist * this.minDist)) {
            return false;
        }
        this.owner = LivingEntity2;
        return true;
    }

    public boolean canContinueToUse() {
        return !this.noPath() && this.ampithere.distanceToSqr((Entity)this.owner) > (double)(this.maxDist * this.maxDist) && !this.ampithere.isOrderedToSit();
    }

    private boolean noPath() {
        if (!this.ampithere.isFlying()) {
            return this.ampithere.getNavigation().isDone();
        }
        return false;
    }

    public void start() {
        this.timeToRecalcPath = 0;
        this.oldWaterCost = this.ampithere.getPathfindingMalus(PathType.WATER);
        this.ampithere.setPathfindingMalus(PathType.WATER, 0.0f);
    }

    public void stop() {
        this.owner = null;
        this.ampithere.getNavigation().stop();
        this.ampithere.setPathfindingMalus(PathType.WATER, this.oldWaterCost);
    }

    public void tick() {
        this.ampithere.getLookControl().setLookAt((Entity)this.owner, 10.0f, (float)this.ampithere.getMaxHeadXRot());
        if (!this.ampithere.isOrderedToSit() && --this.timeToRecalcPath <= 0) {
            this.timeToRecalcPath = 10;
            this.tryMoveTo();
            if (!this.ampithere.isLeashed() && !this.ampithere.isPassenger() && this.ampithere.distanceToSqr((Entity)this.owner) >= 144.0) {
                int i = Mth.floor((double)this.owner.getX()) - 2;
                int j = Mth.floor((double)this.owner.getZ()) - 2;
                int k = Mth.floor((double)this.owner.getBoundingBox().minY);
                for (int l = 0; l <= 4; ++l) {
                    for (int i1 = 0; i1 <= 4; ++i1) {
                        if (l >= 1 && i1 >= 1 && l <= 3 && i1 <= 3 || !this.canTeleportToBlock(new BlockPos(i, j, k))) continue;
                        this.ampithere.moveTo((float)(i + l) + 0.5f, k, (float)(j + i1) + 0.5f, this.ampithere.getYRot(), this.ampithere.getXRot());
                        this.ampithere.getNavigation().stop();
                        return;
                    }
                }
            }
        }
    }

    protected boolean canTeleportToBlock(BlockPos pos) {
        BlockState blockstate = this.world.getBlockState(pos);
        return blockstate.isValidSpawn((BlockGetter)this.world, pos, this.ampithere.getType()) && this.world.isEmptyBlock(pos.above()) && this.world.isEmptyBlock(pos.above(2));
    }

    private void tryMoveTo() {
        if (!this.ampithere.isFlying()) {
            this.ampithere.getNavigation().moveTo((Entity)this.owner, this.followSpeed);
        } else {
            this.ampithere.getMoveControl().setWantedPosition(this.owner.getX(), this.owner.getY() + (double)this.owner.getEyeHeight() + 5.0 + (double)this.ampithere.getRandom().nextInt(8), this.owner.getZ(), 0.25);
        }
    }
}

