/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.entity;

import com.iafenvoy.iceandfire.entity.EntityMultipartPart;
import com.iafenvoy.iceandfire.entity.EntitySeaSerpent;
import com.iafenvoy.iceandfire.entity.EntitySlowPart;
import com.iafenvoy.iceandfire.entity.util.dragon.IDragonProjectile;
import com.iafenvoy.iceandfire.registry.IafParticles;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Fireball;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class EntitySeaSerpentBubbles
extends Fireball
implements IDragonProjectile {
    public EntitySeaSerpentBubbles(EntityType<? extends Fireball> t, Level worldIn) {
        super(t, worldIn);
    }

    public EntitySeaSerpentBubbles(EntityType<? extends Fireball> t, Level worldIn, double posX, double posY, double posZ, double accelX, double accelY, double accelZ) {
        super(t, posX, posY, posZ, new Vec3(accelX, accelY, accelZ), worldIn);
    }

    public EntitySeaSerpentBubbles(EntityType<? extends Fireball> t, Level worldIn, EntitySeaSerpent shooter, double accelX, double accelY, double accelZ) {
        super(t, (LivingEntity)shooter, new Vec3(accelX, accelY, accelZ), worldIn);
    }

    public boolean isPickable() {
        return false;
    }

    protected boolean shouldBurn() {
        return false;
    }

    public void tick() {
        Entity shootingEntity = this.getOwner();
        if (this.tickCount > 400) {
            this.remove(Entity.RemovalReason.DISCARDED);
        }
        this.autoTarget();
        if (this.level().isClientSide || (shootingEntity == null || !shootingEntity.isAlive()) && this.level().hasChunkAt(this.blockPosition())) {
            this.baseTick();
            HitResult raytraceresult = ProjectileUtil.getHitResultOnMoveVector((Entity)this, this::canHitEntity);
            if (raytraceresult.getType() != HitResult.Type.MISS) {
                this.onHit(raytraceresult);
            }
            Vec3 vec3d = this.getDeltaMovement();
            double d0 = this.getX() + vec3d.x;
            double d1 = this.getY() + vec3d.y;
            double d2 = this.getZ() + vec3d.z;
            ProjectileUtil.rotateTowardsMovement((Entity)this, (float)0.2f);
            float f = this.getInertia();
            if (this.level().isClientSide) {
                for (int i = 0; i < 3; ++i) {
                    this.level().addParticle((ParticleOptions)IafParticles.SERPENT_BUBBLE.get(), this.getX() + (double)(this.random.nextFloat() * this.getBbWidth()) - (double)this.getBbWidth() * 0.5, this.getY() - 0.5, this.getZ() + (double)(this.random.nextFloat() * this.getBbWidth()) - (double)this.getBbWidth() * 0.5, 0.0, 0.0, 0.0);
                }
            }
            this.setDeltaMovement(vec3d.add(vec3d.normalize().multiply(this.stuckSpeedMultiplier)).scale((double)f));
            this.setPos(d0, d1, d2);
            this.setPos(this.getX(), this.getY(), this.getZ());
        }
        this.setPos(this.getX(), this.getY(), this.getZ());
        if (this.tickCount > 20 && !this.isInWaterOrRain()) {
            this.remove(Entity.RemovalReason.DISCARDED);
        }
    }

    protected boolean canHitEntity(Entity entityIn) {
        return super.canHitEntity(entityIn) && !(entityIn instanceof EntityMultipartPart) && !(entityIn instanceof EntitySeaSerpentBubbles);
    }

    public void autoTarget() {
        Entity shootingEntity;
        if (this.level().isClientSide && (!((shootingEntity = this.getOwner()) instanceof EntitySeaSerpent) || ((EntitySeaSerpent)shootingEntity).getTarget() == null) && this.tickCount > 20) {
            this.remove(Entity.RemovalReason.DISCARDED);
        }
    }

    protected ParticleOptions getTrailParticle() {
        return ParticleTypes.BUBBLE;
    }

    public boolean hurt(DamageSource source, float amount) {
        return false;
    }

    public float getPickRadius() {
        return 0.0f;
    }

    protected void onHit(HitResult movingObject) {
        boolean flag = this.level().getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING);
        if (!this.level().isClientSide && movingObject.getType() == HitResult.Type.ENTITY) {
            Entity entity = ((EntityHitResult)movingObject).getEntity();
            if (entity instanceof EntitySlowPart) {
                return;
            }
            Entity shootingEntity = this.getOwner();
            if (shootingEntity instanceof EntitySeaSerpent) {
                EntitySeaSerpent dragon = (EntitySeaSerpent)shootingEntity;
                if (dragon.isAlliedTo(entity) || dragon.is(entity)) {
                    return;
                }
                entity.hurt(this.level().damageSources().mobAttack((LivingEntity)dragon), 6.0f);
            }
        }
    }
}

