/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.entity;

import com.iafenvoy.iceandfire.data.IafSkullType;
import com.iafenvoy.iceandfire.entity.util.IBlacklistedFromStatues;
import com.iafenvoy.iceandfire.entity.util.IDeadMob;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class EntityMobSkull
extends Animal
implements IBlacklistedFromStatues,
IDeadMob {
    private static final EntityDataAccessor<Float> SKULL_DIRECTION = SynchedEntityData.defineId(EntityMobSkull.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Integer> SKULL_ENUM = SynchedEntityData.defineId(EntityMobSkull.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public EntityMobSkull(EntityType<? extends EntityMobSkull> t, Level worldIn) {
        super(t, worldIn);
        this.noCulling = true;
    }

    public static AttributeSupplier.Builder bakeAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 10.0).add(Attributes.MOVEMENT_SPEED, 0.0);
    }

    public boolean isInvulnerableTo(DamageSource i) {
        return i.getEntity() != null;
    }

    public boolean isNoAi() {
        return true;
    }

    public boolean isOnWall() {
        return this.level().isEmptyBlock(this.blockPosition().below());
    }

    public void onUpdate() {
        this.yBodyRotO = 0.0f;
        this.yHeadRotO = 0.0f;
        this.yBodyRot = 0.0f;
        this.yHeadRot = 0.0f;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(SKULL_DIRECTION, (Object)Float.valueOf(0.0f));
        builder.define(SKULL_ENUM, (Object)0);
    }

    public float getYRot() {
        return ((Float)this.getEntityData().get(SKULL_DIRECTION)).floatValue();
    }

    public void setYRot(float var1) {
        this.getEntityData().set(SKULL_DIRECTION, (Object)Float.valueOf(var1));
    }

    private int getEnumOrdinal() {
        return (Integer)this.getEntityData().get(SKULL_ENUM);
    }

    private void setEnumOrdinal(int var1) {
        this.getEntityData().set(SKULL_ENUM, (Object)var1);
    }

    public IafSkullType getSkullType() {
        return IafSkullType.values()[Mth.clamp((int)this.getEnumOrdinal(), (int)0, (int)(IafSkullType.values().length - 1))];
    }

    public void setSkullType(IafSkullType skullType) {
        this.setEnumOrdinal(skullType.ordinal());
    }

    public boolean hurt(DamageSource var1, float var2) {
        this.turnIntoItem();
        return super.hurt(var1, var2);
    }

    public void turnIntoItem() {
        if (this.isRemoved()) {
            return;
        }
        this.remove(Entity.RemovalReason.DISCARDED);
        ItemStack stack = new ItemStack((ItemLike)this.getSkullType().getSkullItem(), 1);
        if (!this.level().isClientSide) {
            this.spawnAtLocation(stack, 0.0f);
        }
    }

    public boolean isFood(ItemStack stack) {
        return false;
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        if (player.isShiftKeyDown()) {
            this.setYRot(player.getYRot());
        }
        return super.mobInteract(player, hand);
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        this.setYRot(compound.getFloat("SkullYaw"));
        this.setEnumOrdinal(compound.getInt("SkullType"));
        super.readAdditionalSaveData(compound);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        compound.putFloat("SkullYaw", this.getYRot());
        compound.putInt("SkullType", this.getEnumOrdinal());
        super.addAdditionalSaveData(compound);
    }

    public boolean isPushable() {
        return false;
    }

    protected void doPush(Entity entity) {
    }

    @Override
    public boolean canBeTurnedToStone() {
        return false;
    }

    @Override
    public boolean isMobDead() {
        return true;
    }

    public AgeableMob getBreedOffspring(ServerLevel serverWorld, AgeableMob ageable) {
        return null;
    }

    public boolean isPersistenceRequired() {
        return true;
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }
}

