/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.entity;

import com.iafenvoy.iceandfire.config.IafCommonConfig;
import com.iafenvoy.iceandfire.entity.EntityDreadBeast;
import com.iafenvoy.iceandfire.entity.EntityDreadGhoul;
import com.iafenvoy.iceandfire.entity.EntityDreadLichSkull;
import com.iafenvoy.iceandfire.entity.EntityDreadMob;
import com.iafenvoy.iceandfire.entity.EntityDreadScuttler;
import com.iafenvoy.iceandfire.entity.EntityDreadThrall;
import com.iafenvoy.iceandfire.entity.ai.DreadAITargetNonDread;
import com.iafenvoy.iceandfire.entity.ai.DreadLichAIStrife;
import com.iafenvoy.iceandfire.entity.util.IAnimalFear;
import com.iafenvoy.iceandfire.entity.util.IDreadMob;
import com.iafenvoy.iceandfire.entity.util.IVillagerFear;
import com.iafenvoy.iceandfire.entity.util.dragon.DragonUtils;
import com.iafenvoy.iceandfire.registry.IafEntities;
import com.iafenvoy.iceandfire.registry.IafItems;
import com.iafenvoy.iceandfire.registry.IafParticles;
import com.iafenvoy.iceandfire.registry.IafSounds;
import com.iafenvoy.iceandfire.world.GenerationConstants;
import com.iafenvoy.uranus.animation.Animation;
import com.iafenvoy.uranus.animation.AnimationHandler;
import com.iafenvoy.uranus.animation.IAnimatedEntity;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class EntityDreadLich
extends EntityDreadMob
implements IAnimatedEntity,
IVillagerFear,
IAnimalFear,
RangedAttackMob {
    public static final Animation ANIMATION_SPAWN = Animation.create((int)40);
    public static final Animation ANIMATION_SUMMON = Animation.create((int)15);
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.defineId(EntityDreadLich.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> MINION_COUNT = SynchedEntityData.defineId(EntityDreadLich.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private final DreadLichAIStrife aiArrowAttack = new DreadLichAIStrife(this, 1.0, 20, 15.0f);
    private final MeleeAttackGoal aiAttackOnCollide = new MeleeAttackGoal((PathfinderMob)this, 1.0, false);
    private int animationTick;
    private Animation currentAnimation;
    private int fireCooldown = 0;
    private int minionCooldown = 0;

    public EntityDreadLich(EntityType<? extends EntityDreadMob> type, Level worldIn) {
        super(type, worldIn);
    }

    public static boolean canLichSpawnOn(EntityType<? extends Mob> typeIn, ServerLevelAccessor worldIn, MobSpawnType reason, BlockPos pos, RandomSource randomIn) {
        BlockPos blockpos = pos.below();
        if (reason == MobSpawnType.SPAWNER) {
            return true;
        }
        if (!GenerationConstants.isFarEnoughFromSpawn(pos)) {
            return false;
        }
        if (!worldIn.getBlockState(blockpos).isValidSpawn((BlockGetter)worldIn, blockpos, typeIn)) {
            return false;
        }
        return randomIn.nextDouble() < (Double)IafCommonConfig.INSTANCE.lich.spawnChance.getValue();
    }

    public static AttributeSupplier.Builder bakeAttributes() {
        return EntityDreadLich.createMobAttributes().add(Attributes.MAX_HEALTH, 50.0).add(Attributes.MOVEMENT_SPEED, 0.3).add(Attributes.ATTACK_DAMAGE, 1.0).add(Attributes.FOLLOW_RANGE, 128.0).add(Attributes.ARMOR, 2.0);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{IDreadMob.class}));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, (Predicate)((com.google.common.base.Predicate)DragonUtils::canHostilesTarget)));
        this.targetSelector.addGoal(3, (Goal)new DreadAITargetNonDread((Mob)this, LivingEntity.class, false, (Predicate<LivingEntity>)((com.google.common.base.Predicate)entity -> entity instanceof LivingEntity && DragonUtils.canHostilesTarget((Entity)entity))));
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(VARIANT, (Object)0);
        builder.define(MINION_COUNT, (Object)0);
    }

    @Override
    public void aiStep() {
        super.aiStep();
        if (this.getAnimation() == ANIMATION_SPAWN && this.getAnimationTick() < 30) {
            BlockState belowBlock = this.level().getBlockState(this.blockPosition().below());
            if (belowBlock.getBlock() != Blocks.AIR) {
                for (int i = 0; i < 5; ++i) {
                    this.level().addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, belowBlock), this.getX() + (double)(this.random.nextFloat() * this.getBbWidth() * 2.0f) - (double)this.getBbWidth(), this.getBoundingBox().minY, this.getZ() + (double)(this.random.nextFloat() * this.getBbWidth() * 2.0f) - (double)this.getBbWidth(), this.random.nextGaussian() * 0.02, this.random.nextGaussian() * 0.02, this.random.nextGaussian() * 0.02);
                }
            }
            this.setDeltaMovement(0.0, this.getDeltaMovement().y, this.getDeltaMovement().z);
        }
        if (this.level().isClientSide && this.getAnimation() == ANIMATION_SUMMON) {
            double d0 = 0.0;
            double d1 = 0.0;
            double d2 = 0.0;
            float f = this.yBodyRot * ((float)Math.PI / 180) + Mth.cos((float)((float)this.tickCount * 0.6662f)) * 0.25f;
            float f1 = Mth.cos((float)f);
            float f2 = Mth.sin((float)f);
            this.level().addParticle((ParticleOptions)IafParticles.DREAD_TORCH.get(), this.getX() + (double)f1 * 0.6, this.getY() + 1.8, this.getZ() + (double)f2 * 0.6, d0, d1, d2);
            this.level().addParticle((ParticleOptions)IafParticles.DREAD_TORCH.get(), this.getX() - (double)f1 * 0.6, this.getY() + 1.8, this.getZ() - (double)f2 * 0.6, d0, d1, d2);
        }
        if (this.fireCooldown > 0) {
            --this.fireCooldown;
        }
        if (this.minionCooldown > 0) {
            --this.minionCooldown;
        }
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
    }

    protected void populateDefaultEquipmentSlots(RandomSource pRandom, DifficultyInstance pDifficulty) {
        super.populateDefaultEquipmentSlots(pRandom, pDifficulty);
        this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)IafItems.LICH_STAFF.get()));
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, SpawnGroupData spawnDataIn) {
        SpawnGroupData data = super.finalizeSpawn(worldIn, difficultyIn, reason, spawnDataIn);
        this.setAnimation(ANIMATION_SPAWN);
        this.populateDefaultEquipmentSlots(worldIn.getRandom(), difficultyIn);
        this.setVariant(this.random.nextInt(5));
        this.setCombatTask();
        return data;
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    @Override
    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("Variant", this.getVariant());
        compound.putInt("MinionCount", this.getMinionCount());
    }

    @Override
    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setVariant(compound.getInt("Variant"));
        this.setMinionCount(compound.getInt("MinionCount"));
        this.setCombatTask();
    }

    public int getVariant() {
        return (Integer)this.entityData.get(VARIANT);
    }

    public void setVariant(int variant) {
        this.entityData.set(VARIANT, (Object)variant);
    }

    public int getMinionCount() {
        return (Integer)this.entityData.get(MINION_COUNT);
    }

    public void setMinionCount(int minions) {
        this.entityData.set(MINION_COUNT, (Object)minions);
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    public Animation[] getAnimations() {
        return new Animation[]{ANIMATION_SPAWN, ANIMATION_SUMMON};
    }

    @Override
    public boolean shouldAnimalsFear(Entity entity) {
        return true;
    }

    @Override
    public Entity getCommander() {
        return null;
    }

    public void setItemSlot(EquipmentSlot slotIn, ItemStack stack) {
        super.setItemSlot(slotIn, stack);
        if (!this.level().isClientSide && slotIn == EquipmentSlot.MAINHAND) {
            this.setCombatTask();
        }
    }

    public void setCombatTask() {
        if (this.level() != null && !this.level().isClientSide) {
            this.goalSelector.removeGoal((Goal)this.aiAttackOnCollide);
            this.goalSelector.removeGoal((Goal)this.aiArrowAttack);
            ItemStack itemstack = this.getMainHandItem();
            if (itemstack.getItem() == IafItems.LICH_STAFF.get()) {
                int i = 100;
                this.aiArrowAttack.setAttackCooldown(i);
                this.goalSelector.addGoal(4, (Goal)this.aiArrowAttack);
            } else {
                this.goalSelector.addGoal(4, (Goal)this.aiAttackOnCollide);
            }
        }
    }

    public void performRangedAttack(LivingEntity target, float distanceFactor) {
        boolean flag = false;
        if (this.getMinionCount() < 5 && this.minionCooldown == 0) {
            this.setAnimation(ANIMATION_SUMMON);
            this.playSound((SoundEvent)IafSounds.DREAD_LICH_SUMMON.get(), this.getSoundVolume(), this.getVoicePitch());
            Mob minion = this.getRandomNewMinion();
            int x = (int)this.getX() - 5 + this.random.nextInt(10);
            int z = (int)this.getZ() - 5 + this.random.nextInt(10);
            double y = this.getHeightFromXZ(x, z);
            minion.moveTo((double)x + 0.5, y, (double)z + 0.5, this.getYRot(), this.getXRot());
            minion.setTarget(target);
            Level currentLevel = this.level();
            if (currentLevel instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverWorldAccess = (ServerLevelAccessor)currentLevel;
                minion.finalizeSpawn(serverWorldAccess, currentLevel.getCurrentDifficultyAt(this.blockPosition()), MobSpawnType.MOB_SUMMONED, null);
            }
            if (minion instanceof EntityDreadMob) {
                EntityDreadMob mob = (EntityDreadMob)minion;
                mob.setCommanderId(this.getUUID());
            }
            if (!currentLevel.isClientSide) {
                currentLevel.addFreshEntity((Entity)minion);
            }
            this.minionCooldown = 100;
            this.setMinionCount(this.getMinionCount() + 1);
            flag = true;
        }
        if (this.fireCooldown == 0 && !flag) {
            this.swing(InteractionHand.MAIN_HAND);
            this.playSound(SoundEvents.ZOMBIE_INFECT, this.getSoundVolume(), this.getVoicePitch());
            EntityDreadLichSkull skull = new EntityDreadLichSkull((EntityType<? extends AbstractArrow>)((EntityType)IafEntities.DREAD_LICH_SKULL.get()), this.level(), (LivingEntity)this, 6.0);
            double d0 = target.getX() - this.getX();
            double d1 = target.getBoundingBox().minY + (double)(target.getBbHeight() * 2.0f) - skull.getY();
            double d2 = target.getZ() - this.getZ();
            double d3 = Math.sqrt((float)(d0 * d0 + d2 * d2));
            skull.shoot(d0, d1 + d3 * (double)0.2f, d2, 0.0f, 14 - this.level().getDifficulty().getId() * 4);
            this.level().addFreshEntity((Entity)skull);
            this.fireCooldown = 100;
        }
    }

    private Mob getRandomNewMinion() {
        float chance = this.random.nextFloat();
        if (chance > 0.5f) {
            return new EntityDreadThrall((EntityType<? extends EntityDreadThrall>)((EntityType)IafEntities.DREAD_THRALL.get()), this.level());
        }
        if (chance > 0.35f) {
            return new EntityDreadGhoul((EntityType<? extends EntityDreadGhoul>)((EntityType)IafEntities.DREAD_GHOUL.get()), this.level());
        }
        if (chance > 0.15f) {
            return new EntityDreadBeast((EntityType<? extends EntityDreadBeast>)((EntityType)IafEntities.DREAD_BEAST.get()), this.level());
        }
        return new EntityDreadScuttler((EntityType<? extends EntityDreadScuttler>)((EntityType)IafEntities.DREAD_SCUTTLER.get()), this.level());
    }

    private double getHeightFromXZ(int x, int z) {
        BlockPos thisPos = new BlockPos(x, (int)(this.getY() + 7.0), z);
        while (this.level().isEmptyBlock(thisPos) && thisPos.getY() > 2) {
            thisPos = thisPos.below();
        }
        return (double)thisPos.getY() + 1.0;
    }

    @Override
    public boolean isAlliedTo(Entity entityIn) {
        return entityIn instanceof IDreadMob || super.isAlliedTo(entityIn);
    }

    protected SoundEvent getAmbientSound() {
        return SoundEvents.STRAY_AMBIENT;
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return SoundEvents.STRAY_HURT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.STRAY_DEATH;
    }

    protected void playStepSound(BlockPos pos, Block blockIn) {
        this.playSound(SoundEvents.STRAY_STEP, 0.15f, 1.0f);
    }
}

