/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.data;

import com.iafenvoy.iceandfire.item.ItemMobSkull;
import com.iafenvoy.iceandfire.registry.IafItems;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.Locale;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.SkullBlock;

public enum IafSkullType implements SkullBlock.Type
{
    HIPPOGRYPH,
    CYCLOPS,
    COCKATRICE,
    STYMPHALIAN,
    TROLL,
    AMPHITHERE,
    SEASERPENT,
    HYDRA;

    private final String itemResourceName = this.name().toLowerCase(Locale.ROOT) + "_skull";
    private RegistrySupplier<Item> skullItem;

    public static void initItems() {
        for (IafSkullType skull : IafSkullType.values()) {
            skull.skullItem = IafItems.register(skull.itemResourceName, () -> new ItemMobSkull(skull));
        }
    }

    public Item getSkullItem() {
        return (Item)this.skullItem.get();
    }

    public String getSerializedName() {
        return this.itemResourceName;
    }
}

