/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.net;

import dev.architectury.networking.NetworkManager;
import dev.ftb.mods.ftbquests.api.FTBQuestsAPI;
import dev.ftb.mods.ftbquests.net.TogglePinnedResponseMessage;
import dev.ftb.mods.ftbquests.quest.ServerQuestFile;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public record TogglePinnedMessage(long id) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<TogglePinnedMessage> TYPE = new CustomPacketPayload.Type(FTBQuestsAPI.rl("toggle_pinned_message"));
    public static final StreamCodec<FriendlyByteBuf, TogglePinnedMessage> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_LONG, TogglePinnedMessage::id, TogglePinnedMessage::new);

    public CustomPacketPayload.Type<TogglePinnedMessage> type() {
        return TYPE;
    }

    public static void handle(TogglePinnedMessage message, NetworkManager.PacketContext context) {
        context.queue(() -> {
            ServerPlayer player = (ServerPlayer)context.getPlayer();
            ServerQuestFile.INSTANCE.getTeamData((Player)player).ifPresent(data -> {
                boolean newPinned = !data.isQuestPinned((Player)player, message.id);
                data.setQuestPinned((Player)player, message.id, newPinned);
                NetworkManager.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new TogglePinnedResponseMessage(message.id, newPinned));
            });
        });
    }
}

