/*
 * Decompiled with CFR 0.152.
 */
package sirttas.dpanvil.data.network.payload;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import net.minecraft.Util;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.apache.logging.log4j.util.Supplier;
import org.jetbrains.annotations.NotNull;
import sirttas.dpanvil.DataPackAnvil;
import sirttas.dpanvil.api.DataPackAnvilApi;
import sirttas.dpanvil.api.data.IDataManager;
import sirttas.dpanvil.data.DataHandler;
import sirttas.dpanvil.data.DataManagerWrapper;
import sirttas.dpanvil.data.network.payload.PayloadHelper;
import sirttas.dpanvil.data.serializer.IJsonDataSerializer;
import sirttas.dpanvil.registry.RegistryListener;

public record ReloadDataPayload(List<SubPayload<?, ?>> messages) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ReloadDataPayload> TYPE = PayloadHelper.createType("reload_data");
    public static final StreamCodec<FriendlyByteBuf, ReloadDataPayload> STREAM_CODEC = StreamCodec.of((b, p) -> p.write((FriendlyByteBuf)b), ReloadDataPayload::new);

    public ReloadDataPayload(Collection<ResourceKey<IDataManager<?>>> managers) {
        this(managers.stream().map(m -> SubPayload.create(m, (k, s) -> Collections.emptyMap())).toList());
    }

    public ReloadDataPayload(FriendlyByteBuf buf) {
        this((List)Util.make(() -> {
            ArrayList messages = new ArrayList();
            int size = buf.readInt();
            for (int i = 0; i < size; ++i) {
                messages.add(SubPayload.load(buf));
            }
            return List.copyOf(messages);
        }));
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeInt(this.messages.size());
        for (SubPayload<?, ?> message : this.messages) {
            message.write(buf);
        }
        Supplier[] supplierArray = new Supplier[1];
        supplierArray[0] = () -> ((FriendlyByteBuf)buf).writerIndex();
        DataPackAnvilApi.LOGGER.debug("Sending DataPack Anvil packet with size: {} bytes", supplierArray);
    }

    public void handle(IPayloadContext ctx) {
        ctx.enqueueWork(() -> RegistryListener.getInstance().listen(r -> {
            this.messages.forEach(SubPayload::handle);
            DataHandler.onDPAnvilUpdate();
        }));
    }

    @NotNull
    public CustomPacketPayload.Type<ReloadDataPayload> type() {
        return TYPE;
    }

    private record SubPayload<T, I>(ResourceKey<IDataManager<T>> key, IDataManager<T> manager, IJsonDataSerializer<T, I> serializer, Map<ResourceLocation, T> data, Map<ResourceLocation, I> intermediateData) {
        public static <T, I> SubPayload<T, I> load(FriendlyByteBuf buf) {
            return SubPayload.create(IDataManager.createManagerKey(buf.readResourceLocation()), (k, s) -> {
                try {
                    int mapSize = buf.readInt();
                    HashMap data = HashMap.newHashMap(mapSize);
                    for (int i = 0; i < mapSize; ++i) {
                        data.put(buf.readResourceLocation(), s.read(buf));
                    }
                    return Map.copyOf(data);
                }
                catch (Exception e) {
                    throw new IllegalStateException("Error while decoding network packet for DataManger " + String.valueOf(k), e);
                }
            });
        }

        public static <T, I> SubPayload<T, I> create(ResourceKey<? super IDataManager<T>> key, BiFunction<ResourceKey<IDataManager<T>>, IJsonDataSerializer<T, I>, Map<ResourceLocation, I>> dataBuilder) {
            ResourceKey<? super IDataManager<T>> k = key;
            Object manager = DataPackAnvil.WRAPPER.getManager(key);
            Object serializer = DataPackAnvil.WRAPPER.getSerializer(key);
            Map data = Map.copyOf(manager.getData());
            Map<ResourceLocation, I> intermediateData = dataBuilder.apply((ResourceKey<IDataManager<ResourceKey<? super IDataManager<T>>>>)k, (IJsonDataSerializer<ResourceKey<? super IDataManager<T>>, I>)serializer);
            return new SubPayload(k, manager, serializer, data, intermediateData);
        }

        public void write(FriendlyByteBuf buf) {
            buf.writeResourceLocation(this.key.location());
            buf.writeInt(this.data.size());
            this.data.forEach((loc, prop) -> this.encodeSingleData(buf, (ResourceLocation)loc, (T)prop));
        }

        private void encodeSingleData(FriendlyByteBuf buf, ResourceLocation loc, T prop) {
            try {
                buf.writeResourceLocation(loc);
                this.serializer.write(prop, buf);
            }
            catch (Exception e) {
                throw new IllegalStateException("Error while encoding network packet for DataManger " + String.valueOf(this.key) + ", " + String.valueOf(loc) + " has invalid data", e);
            }
        }

        public void handle() {
            try {
                HashMap<ResourceLocation, T> newData = new HashMap<ResourceLocation, T>(this.manager.getData());
                for (Map.Entry<ResourceLocation, I> entry : this.intermediateData.entrySet()) {
                    newData.put(entry.getKey(), this.serializer.read(entry.getValue()));
                }
                this.manager.setData(newData);
            }
            catch (Exception e) {
                DataManagerWrapper.logManagerException(this.key, e);
            }
        }
    }
}

