/*
 * Decompiled with CFR 0.152.
 */
package sirttas.dpanvil.data.manager;

import com.google.gson.JsonElement;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceKey;
import sirttas.dpanvil.api.data.IDataManager;
import sirttas.dpanvil.data.manager.AbstractBuilder;
import sirttas.dpanvil.data.manager.SimpleDataManager;

public class SimpleDataManagerBuilder<T>
extends AbstractBuilder<T> {
    protected boolean hasInheritance = false;

    public SimpleDataManagerBuilder(Class<T> type, @Nonnull ResourceKey<IDataManager<T>> key) {
        super(type, key);
    }

    @Override
    public IDataManager.Builder<T> withInheritance() {
        this.hasInheritance = true;
        return this;
    }

    @Override
    public <R> IDataManager.Builder<T> merged(Function<Stream<R>, T> merger, Function<JsonElement, R> rawParser) {
        if (this.hasInheritance) {
            throw new UnsupportedOperationException("Inheritance is not supported for merged data managers.");
        }
        return super.merged(merger, rawParser);
    }

    @Override
    public IDataManager<T> build() {
        return new SimpleDataManager(this.key, this.type, this.folder, this.defaultValueFactory, this.idSetter, this.hasInheritance);
    }
}

