/*
 * Decompiled with CFR 0.152.
 */
package sirttas.dpanvil.data.manager;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import org.jetbrains.annotations.NotNull;
import sirttas.dpanvil.DataPackAnvil;
import sirttas.dpanvil.api.DataPackAnvilApi;
import sirttas.dpanvil.api.data.IDataManager;
import sirttas.dpanvil.data.DataManagerWrapper;
import sirttas.dpanvil.data.manager.AbstractDataManager;
import sirttas.dpanvil.data.manager.InheritanceResolver;
import sirttas.dpanvil.registry.RegistryListener;

public class SimpleDataManager<T>
extends AbstractDataManager<T, JsonElement> {
    private final boolean hasInheritance;

    public SimpleDataManager(ResourceKey<IDataManager<T>> key, Class<T> contentType, String folder, Function<ResourceLocation, T> defaultValueFactory, BiConsumer<T, ResourceLocation> idSetter, boolean hasInheritance) {
        super(key, contentType, folder, defaultValueFactory, idSetter);
        this.hasInheritance = hasInheritance;
    }

    @NotNull
    protected Map<ResourceLocation, JsonElement> prepare(ResourceManager resourceManager, @NotNull ProfilerFiller profiler) {
        HashMap map = Maps.newHashMap();
        int i = this.folder.length() + 1;
        for (Map.Entry entry : resourceManager.listResources(this.folder, file -> file.getPath().endsWith(".json")).entrySet()) {
            ResourceLocation resourceLocation = (ResourceLocation)entry.getKey();
            String path = resourceLocation.getPath();
            ResourceLocation resourceId = ResourceLocation.fromNamespaceAndPath((String)resourceLocation.getNamespace(), (String)path.substring(i, path.length() - 5));
            try {
                InputStream inputstream = ((Resource)entry.getValue()).open();
                try {
                    BufferedReader reader = new BufferedReader(new InputStreamReader(inputstream, StandardCharsets.UTF_8));
                    JsonElement jsonelement = (JsonElement)GsonHelper.fromJson((Gson)GSON, (Reader)reader, JsonElement.class);
                    if (jsonelement != null) {
                        map.put(resourceId, jsonelement);
                        continue;
                    }
                    DataPackAnvilApi.LOGGER.error("Couldn't load data file {} from {} as it's null or empty", (Object)resourceId, (Object)resourceLocation);
                }
                finally {
                    if (inputstream == null) continue;
                    inputstream.close();
                }
            }
            catch (IOException e) {
                DataPackAnvilApi.LOGGER.error("Couldn't parse data file {} from {}", (Object)resourceId, (Object)resourceLocation, (Object)e);
            }
        }
        if (this.hasInheritance) {
            return new InheritanceResolver(map).resolve();
        }
        return map;
    }

    protected void apply(@NotNull Map<ResourceLocation, JsonElement> objects, @NotNull ResourceManager resourceManager, @NotNull ProfilerFiller profiler) {
        RegistryListener.getInstance().listen(r -> {
            try {
                HashMap map = Maps.newHashMap();
                Object serializer = DataPackAnvil.WRAPPER.getSerializer(this.key);
                objects.forEach((loc, jsonObject) -> {
                    try {
                        Object value = serializer.read(jsonObject);
                        this.idSetter.accept(value, loc);
                        map.put(loc, value);
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Failed to load data file " + String.valueOf(loc), e);
                    }
                });
                this.setData(map);
            }
            catch (Exception e) {
                DataManagerWrapper.logManagerException(this.key, e);
            }
        });
    }
}

