/*
 * Decompiled with CFR 0.152.
 */
package sirttas.dpanvil.data.manager;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import org.jetbrains.annotations.NotNull;
import sirttas.dpanvil.DataPackAnvil;
import sirttas.dpanvil.api.DataPackAnvilApi;
import sirttas.dpanvil.api.data.IDataManager;
import sirttas.dpanvil.data.DataManagerWrapper;
import sirttas.dpanvil.data.manager.AbstractDataManager;
import sirttas.dpanvil.registry.RegistryListener;

public class MergedDataManager<R, T>
extends AbstractDataManager<T, List<JsonElement>> {
    private final Function<Stream<R>, T> merger;
    private final Function<JsonElement, R> rawParser;

    public MergedDataManager(ResourceKey<IDataManager<T>> key, Class<T> contentType, String folder, Function<ResourceLocation, T> defaultValueFactory, BiConsumer<T, ResourceLocation> idSetter, Function<Stream<R>, T> merger, Function<JsonElement, R> rawParser) {
        super(key, contentType, folder, defaultValueFactory, idSetter);
        this.merger = merger;
        this.rawParser = rawParser;
    }

    @NotNull
    protected Map<ResourceLocation, List<JsonElement>> prepare(ResourceManager resourceManager, @NotNull ProfilerFiller profiler) {
        HashMap map = Maps.newHashMap();
        int i = this.folder.length() + 1;
        for (Map.Entry entry : resourceManager.listResourceStacks(this.folder, file -> file.getPath().endsWith(".json")).entrySet()) {
            ResourceLocation resourceLocation = (ResourceLocation)entry.getKey();
            String path = resourceLocation.getPath();
            ResourceLocation resourceId = ResourceLocation.fromNamespaceAndPath((String)resourceLocation.getNamespace(), (String)path.substring(i, path.length() - 5));
            ArrayList list = Lists.newArrayList();
            for (Resource resource : (List)entry.getValue()) {
                JsonElement element = MergedDataManager.getElement(resourceLocation, resourceId, resource);
                if (element != null) {
                    JsonObject json;
                    if (element instanceof JsonObject && (json = (JsonObject)element).has("replace") && json.get("replace").getAsBoolean()) {
                        list.clear();
                    }
                    list.add(element);
                    continue;
                }
                DataPackAnvilApi.LOGGER.error("Couldn't load data file {} from {} as it's null or empty", (Object)resourceId, (Object)resourceLocation);
            }
            map.put(resourceId, list);
        }
        return map;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static JsonElement getElement(ResourceLocation resourcelocation, ResourceLocation resourceId, Resource resource) {
        try (InputStream inputstream = resource.open();){
            JsonElement jsonElement;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputstream, StandardCharsets.UTF_8));){
                jsonElement = (JsonElement)GsonHelper.fromJson((Gson)GSON, (Reader)reader, JsonElement.class);
            }
            return jsonElement;
        }
        catch (JsonParseException | IOException | IllegalArgumentException e) {
            DataPackAnvilApi.LOGGER.error("Couldn't parse data file {} from {}", (Object)resourceId, (Object)resourcelocation, (Object)e);
            return null;
        }
    }

    protected void apply(@NotNull Map<ResourceLocation, List<JsonElement>> objects, @NotNull ResourceManager resourceManager, @NotNull ProfilerFiller profiler) {
        RegistryListener.getInstance().listen(r -> {
            try {
                HashMap map = Maps.newHashMap();
                Function<JsonElement, Object> parser = this.rawParser != null ? this.rawParser : json -> DataPackAnvil.WRAPPER.getSerializer(this.key).read((JsonElement)json);
                objects.forEach((loc, list) -> {
                    T value = this.merger.apply(list.stream().map(parser));
                    this.idSetter.accept(value, loc);
                    map.put(loc, value);
                });
                this.setData(map);
            }
            catch (Exception e) {
                DataManagerWrapper.logManagerException(this.key, e);
            }
        });
    }
}

