/*
 * Decompiled with CFR 0.152.
 */
package sirttas.dpanvil.data.manager;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import sirttas.dpanvil.api.DataPackAnvilApi;

class InheritanceResolver {
    private final Map<ResourceLocation, JsonElement> sourceMap;
    private final Map<ResourceLocation, JsonObject> targetMap;

    public InheritanceResolver(Map<ResourceLocation, JsonElement> sourceMap) {
        this.sourceMap = sourceMap;
        this.targetMap = new HashMap<ResourceLocation, JsonObject>();
    }

    public Map<ResourceLocation, JsonElement> resolve() {
        for (Map.Entry<ResourceLocation, JsonElement> entry : this.sourceMap.entrySet()) {
            this.targetMap.computeIfAbsent(entry.getKey(), k -> this.resolve((ResourceLocation)k, (JsonElement)entry.getValue()));
        }
        return Map.copyOf(this.targetMap);
    }

    private JsonObject resolve(ResourceLocation id, JsonElement element) {
        if (!element.isJsonObject()) {
            throw new IllegalArgumentException("Inheritance can only be applied to json objects.");
        }
        JsonObject jsonObject = element.getAsJsonObject();
        if (jsonObject.has("parent")) {
            ResourceLocation parentId = ResourceLocation.parse((String)jsonObject.get("parent").getAsString());
            JsonObject parentElement = this.resolveParent(parentId);
            if (parentElement != null) {
                JsonObject newElement = parentElement.deepCopy();
                jsonObject.entrySet().forEach(e -> newElement.add((String)e.getKey(), (JsonElement)e.getValue()));
                return newElement;
            }
            DataPackAnvilApi.LOGGER.error("Couldn't find parent {} for {}", (Object)parentId, (Object)id);
        }
        return jsonObject;
    }

    private JsonObject resolveParent(ResourceLocation parentId) {
        if (this.targetMap.containsKey(parentId)) {
            return this.targetMap.get(parentId);
        }
        JsonElement parentElement = this.sourceMap.get(parentId);
        if (parentElement != null) {
            return this.resolve(parentId, parentElement);
        }
        return null;
    }
}

