/*
 * Decompiled with CFR 0.152.
 */
package sirttas.dpanvil.data.manager;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import sirttas.dpanvil.DataPackAnvil;
import sirttas.dpanvil.api.data.IDataManager;

public class DataFileCodec<E>
implements Codec<Holder<E>> {
    private final ResourceKey<IDataManager<E>> managerKey;
    private final Codec<E> elementCodec;
    private final boolean allowInline;

    public DataFileCodec(ResourceKey<? extends IDataManager<E>> managerKey, Codec<E> elementCodec, boolean allowInline) {
        this.managerKey = managerKey;
        this.elementCodec = elementCodec;
        this.allowInline = allowInline;
    }

    public <T> DataResult<T> encode(Holder<E> holder, DynamicOps<T> ops, T prefix) {
        return (DataResult)holder.unwrap().map(k -> ResourceLocation.CODEC.encode((Object)k.location(), ops, prefix), e -> this.elementCodec.encode(e, ops, prefix));
    }

    public <T> DataResult<Pair<Holder<E>, T>> decode(DynamicOps<T> ops, T input) {
        Object manager = DataPackAnvil.WRAPPER.getManager(this.managerKey);
        if (manager == null) {
            return DataResult.error(() -> "DataManager does not exist: " + String.valueOf(this.managerKey));
        }
        Optional opt = ResourceLocation.CODEC.decode(ops, input).result();
        if (opt.isEmpty()) {
            return !this.allowInline ? DataResult.error(() -> "Inline definitions not allowed here") : this.elementCodec.decode(ops, input).map(p -> p.mapFirst(Holder::direct));
        }
        Pair pair = (Pair)opt.get();
        ResourceKey<E> resourcekey = IDataManager.createKey(this.managerKey, (ResourceLocation)pair.getFirst());
        DataResult result = DataResult.success(manager.getOrCreateHolder(resourcekey));
        return result.map(v -> Pair.of((Object)v, (Object)pair.getSecond())).setLifecycle(Lifecycle.stable());
    }

    public String toString() {
        return "DataFileCodec[" + String.valueOf(this.managerKey) + " " + String.valueOf(this.elementCodec) + "]";
    }
}

