/*
 * Decompiled with CFR 0.152.
 */
package sirttas.dpanvil.data.manager;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderOwner;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import org.apache.logging.log4j.util.Supplier;
import sirttas.dpanvil.api.DataPackAnvilApi;
import sirttas.dpanvil.api.data.IDataManager;
import sirttas.dpanvil.api.event.DataManagerReloadEvent;

public abstract class AbstractDataManager<T, U>
extends SimplePreparableReloadListener<Map<ResourceLocation, U>>
implements IDataManager<T> {
    protected static final Gson GSON = new GsonBuilder().create();
    private final Class<T> contentType;
    private final Function<ResourceLocation, T> defaultValueFactory;
    private final Map<ResourceLocation, Holder.Reference<T>> references;
    private Map<ResourceLocation, T> data;
    private Map<ResourceLocation, T> remapedData;
    protected final String folder;
    protected final BiConsumer<T, ResourceLocation> idSetter;
    protected final ResourceKey<IDataManager<T>> key;

    protected AbstractDataManager(ResourceKey<IDataManager<T>> key, Class<T> contentType, String folder, Function<ResourceLocation, T> defaultValueFactory, BiConsumer<T, ResourceLocation> idSetter) {
        this.key = key;
        this.contentType = contentType;
        this.defaultValueFactory = defaultValueFactory;
        this.idSetter = idSetter;
        this.folder = folder;
        this.data = ImmutableBiMap.of();
        this.references = new HashMap<ResourceLocation, Holder.Reference<T>>();
        this.remapedData = Collections.emptyMap();
    }

    @Override
    @Nonnull
    public Map<ResourceLocation, T> getData() {
        return this.data;
    }

    @Override
    public ResourceKey<IDataManager<T>> getKey() {
        return this.key;
    }

    @Override
    public void setData(@Nonnull Map<ResourceLocation, T> map) {
        map.forEach((loc, value) -> this.idSetter.accept(value, (ResourceLocation)loc));
        if (this != DataPackAnvilApi.REMAP_KEYS_MANAGER) {
            HashMap remap = new HashMap();
            DataPackAnvilApi.REMAP_KEYS_MANAGER.get(this.key.location()).keys().forEach((k, v) -> {
                Object value = map.get(v);
                if (value != null) {
                    remap.put(k, value);
                }
            });
            this.remapedData = Map.copyOf(remap);
        } else {
            this.remapedData = Collections.emptyMap();
        }
        try {
            this.data = ImmutableBiMap.copyOf(map);
        }
        catch (IllegalArgumentException e) {
            Supplier[] supplierArray = new Supplier[2];
            supplierArray[0] = () -> this.key;
            supplierArray[1] = e::getMessage;
            DataPackAnvilApi.LOGGER.warn("Manager {} has duplicate values ({}), by key search will be slower and may be inconsistent", supplierArray);
            this.data = Map.copyOf(map);
        }
        this.rebindReferences();
        DataPackAnvilApi.LOGGER.info("Loaded {} {}", (Object)this.data.size(), this.key);
        NeoForge.EVENT_BUS.post((Event)new DataManagerReloadEvent(this));
    }

    @Override
    @Nonnull
    public Class<T> getContentType() {
        return this.contentType;
    }

    @Override
    @Nonnull
    public ResourceLocation getId(T value) {
        if (this.data instanceof BiMap) {
            return (ResourceLocation)((BiMap)this.data).inverse().getOrDefault(value, (Object)DataPackAnvilApi.ID_NONE);
        }
        for (Map.Entry<ResourceLocation, T> entry : this.data.entrySet()) {
            if (!entry.getValue().equals(value)) continue;
            return entry.getKey();
        }
        return DataPackAnvilApi.ID_NONE;
    }

    @Override
    public T get(@Nonnull ResourceLocation id) {
        T value = this.data.get(id);
        if (value != null) {
            return value;
        }
        value = this.remapedData.get(id);
        if (value != null) {
            return value;
        }
        return this.defaultValueFactory.apply(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public Holder<T> getOrCreateHolder(@Nonnull ResourceKey<T> key) {
        Map<ResourceLocation, Holder.Reference<T>> map = this.references;
        synchronized (map) {
            return (Holder)this.references.computeIfAbsent(key.location(), resourceLocation -> {
                Holder.Reference reference = Holder.Reference.createStandAlone((HolderOwner)this, (ResourceKey)key);
                this.bindReference((Holder.Reference<T>)reference, (ResourceLocation)resourceLocation);
                return reference;
            });
        }
    }

    @Override
    @Nonnull
    public Holder<T> getOrCreateHolder(@Nonnull ResourceLocation key) {
        return this.getOrCreateHolder(this.createKey(key));
    }

    @Override
    @Nonnull
    public String getFolder() {
        return this.folder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rebindReferences() {
        Map<ResourceLocation, Holder.Reference<T>> map = this.references;
        synchronized (map) {
            this.references.values().forEach(r -> this.bindReference((Holder.Reference<T>)r, r.key().location()));
        }
    }

    private void bindReference(Holder.Reference<T> reference, ResourceLocation resourceLocation) {
        T value = this.get(resourceLocation);
        if (value == null) {
            DataPackAnvilApi.LOGGER.warn("No value found for reference {} in manager {}", (Object)resourceLocation, this.key);
            return;
        }
        reference.bindValue(value);
        if (!reference.isBound()) {
            DataPackAnvilApi.LOGGER.warn("Failed to bind reference {} for manager {}", (Object)resourceLocation, this.key);
        }
    }

    @Nonnull
    private ResourceKey<T> createKey(ResourceLocation l) {
        return IDataManager.createKey(this.key, l);
    }

    public String toString() {
        return this.key != null ? this.key.toString() : this.folder;
    }
}

