/*
 * Decompiled with CFR 0.152.
 */
package sirttas.dpanvil.data;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import org.apache.logging.log4j.util.Supplier;
import org.jetbrains.annotations.NotNull;
import sirttas.dpanvil.api.DataPackAnvilApi;
import sirttas.dpanvil.api.data.IDataManager;
import sirttas.dpanvil.api.imc.DataManagerIMC;
import sirttas.dpanvil.data.serializer.CodecJsonDataSerializer;
import sirttas.dpanvil.data.serializer.IJsonDataSerializer;
import sirttas.dpanvil.registry.RegistryListener;

public class DataManagerWrapper
implements PreparableReloadListener {
    private final Map<ResourceKey<IDataManager<?>>, IDataManager<?>> managers = Maps.newHashMap();
    private final Map<ResourceKey<IDataManager<?>>, IJsonDataSerializer<?, ?>> serializers = Maps.newHashMap();

    public static <T> void logManagerException(ResourceKey<? super IDataManager<T>> key, Throwable e) {
        if (e != null) {
            DataPackAnvilApi.LOGGER.error(() -> "Exception while loading data for manager " + String.valueOf(key) + ":", e);
        }
    }

    public <T, M extends IDataManager<T>> M getManager(ResourceKey<? super IDataManager<T>> key) {
        return (M)this.managers.get(key);
    }

    public <T, M extends IDataManager<T>> M getManager(Class<T> clazz) {
        return (M)((IDataManager)this.managers.values().stream().filter(manager -> manager.getContentType().isAssignableFrom(clazz)).findAny().orElse(null));
    }

    public <T> ResourceKey<IDataManager<T>> getKey(IDataManager<T> manager) {
        return this.managers.entrySet().stream().filter(e -> ((IDataManager)e.getValue()).equals(manager)).map(e -> (ResourceKey)this.cast(e.getKey())).findAny().orElseGet(() -> IDataManager.createManagerKey(DataPackAnvilApi.ID_NONE));
    }

    private <T> T cast(Object key) {
        return (T)key;
    }

    public <T, I, S extends IJsonDataSerializer<T, I>> S getSerializer(ResourceKey<? super IDataManager<T>> key) {
        return (S)this.serializers.get(key);
    }

    public <T> void putManagerFromIMC(java.util.function.Supplier<?> supplier) {
        DataManagerIMC message = (DataManagerIMC)supplier.get();
        IDataManager manager = message.getManager();
        ResourceKey key = (ResourceKey)this.cast(message.getKey());
        this.serializers.put(key, this.buildSerializer(message));
        this.managers.put(key, manager);
    }

    private <T> IJsonDataSerializer<T, ?> buildSerializer(final DataManagerIMC<T> message) {
        Codec<T> codec = message.getCodec();
        final Function<JsonElement, T> readJson = message.getReadJson();
        return codec != null ? new CodecJsonDataSerializer<T>(codec) : new IJsonDataSerializer<T, T>(){

            @Override
            public T read(JsonElement json) {
                if (readJson != null) {
                    return readJson.apply(json);
                }
                throw new IllegalStateException("trying to read json without the proper serialization tools for manager : " + String.valueOf(message.getKey()) + " makes sure you provide a correct json serializer to it.");
            }

            @Override
            public T read(FriendlyByteBuf buf) {
                return message.getReadPacket().apply(buf);
            }

            @Override
            public T read(T data) {
                return data;
            }

            @Override
            public void write(T data, FriendlyByteBuf buf) {
                message.getWritePacket().accept(buf, (FriendlyByteBuf)data);
            }
        };
    }

    public Collection<ResourceKey<IDataManager<?>>> ids() {
        return this.managers.keySet();
    }

    public Map<ResourceKey<IDataManager<?>>, IDataManager<?>> getDataManagers() {
        return this.managers;
    }

    @NotNull
    public CompletableFuture<Void> reload(@NotNull PreparableReloadListener.PreparationBarrier stage, @NotNull ResourceManager resourceManager, @NotNull ProfilerFiller preparationsProfiler, @NotNull ProfilerFiller reloadProfiler, @NotNull Executor backgroundExecutor, @NotNull Executor gameExecutor) {
        if (this.managers.isEmpty()) {
            return CompletableFuture.allOf(new CompletableFuture[0]);
        }
        return ((CompletableFuture)CompletableFuture.runAsync(() -> CompletableFuture.allOf((CompletableFuture[])this.managers.entrySet().stream().map(entry -> ((IDataManager)entry.getValue()).reload(stage, resourceManager, preparationsProfiler, reloadProfiler, backgroundExecutor, gameExecutor).handle(this.handleManagerException((ResourceKey)entry.getKey()))).toArray(CompletableFuture[]::new)), backgroundExecutor).thenCompose(arg_0 -> ((PreparableReloadListener.PreparationBarrier)stage).wait(arg_0))).thenRunAsync(() -> RegistryListener.getInstance().listen(r -> this.postLoad()), gameExecutor);
    }

    private void postLoad() {
        DataPackAnvilApi.LOGGER.debug("DataManagers loading complete: {}", new Supplier[]{() -> {
            StringBuilder logBuilder = new StringBuilder();
            this.managers.forEach((managerId, manager) -> {
                logBuilder.append("\r\n").append(managerId).append(" ").append(manager.getData().size()).append(" entries:\r\n");
                manager.getData().forEach((id, data) -> logBuilder.append("\t").append(id).append(": ").append(data).append("\r\n"));
            });
            return logBuilder.toString();
        }});
    }

    private BiFunction<Void, Throwable, Void> handleManagerException(ResourceKey<IDataManager<?>> key) {
        return (r, e) -> {
            DataManagerWrapper.logManagerException(key, e);
            return r;
        };
    }
}

