/*
 * Decompiled with CFR 0.152.
 */
package sirttas.dpanvil.api.predicate.block.world;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.storage.LevelData;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.ticks.LevelTickAccess;
import org.jetbrains.annotations.NotNull;
import sirttas.dpanvil.api.predicate.block.BlockPosPredicateType;
import sirttas.dpanvil.api.predicate.block.IBlockPosPredicate;

public record CacheBlockPredicate(IBlockPosPredicate predicate) implements IBlockPosPredicate
{
    public static final String NAME = "cache";
    public static final MapCodec<CacheBlockPredicate> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)IBlockPosPredicate.CODEC.fieldOf("value").forGetter(CacheBlockPredicate::predicate)).apply((Applicative)builder, CacheBlockPredicate::new));

    @Override
    public boolean test(@Nonnull LevelReader level, @Nonnull BlockPos pos, @Nullable Direction direction) {
        Object object;
        if (level instanceof ServerLevelAccessor) {
            ServerLevelAccessor accessor = (ServerLevelAccessor)level;
            object = new CacheLevel(accessor);
        } else {
            object = level;
        }
        return this.predicate.test((LevelReader)object, pos, direction);
    }

    public BlockPosPredicateType<CacheBlockPredicate> getType() {
        return (BlockPosPredicateType)BlockPosPredicateType.CACHE.get();
    }

    @Override
    @Nonnull
    public List<Component> getTooltip() {
        return this.predicate.getTooltip();
    }

    private static class CacheLevel
    implements ServerLevelAccessor {
        private final ServerLevel level;
        private final Map<BlockPos, BlockEntity> blockEntityCache;

        public CacheLevel(ServerLevelAccessor level) {
            this.level = level.getLevel();
            this.blockEntityCache = new HashMap<BlockPos, BlockEntity>();
        }

        @Nonnull
        public ServerLevel getLevel() {
            return this.level;
        }

        public long nextSubTickCount() {
            return this.level.nextSubTickCount();
        }

        @Nonnull
        public LevelTickAccess<Block> getBlockTicks() {
            return this.level.getBlockTicks();
        }

        @Nonnull
        public LevelTickAccess<Fluid> getFluidTicks() {
            return this.level.getFluidTicks();
        }

        @Nonnull
        public LevelData getLevelData() {
            return this.level.getLevelData();
        }

        @Nonnull
        public DifficultyInstance getCurrentDifficultyAt(@Nonnull BlockPos pos) {
            return this.level.getCurrentDifficultyAt(pos);
        }

        @Nullable
        public MinecraftServer getServer() {
            return this.level.getServer();
        }

        @Nonnull
        public ChunkSource getChunkSource() {
            return this.level.getChunkSource();
        }

        @Nonnull
        public RandomSource getRandom() {
            return this.level.getRandom();
        }

        public void playSound(@Nullable Player player, @Nonnull BlockPos pos, @Nonnull SoundEvent sound, @Nonnull SoundSource category, float volume, float pitch) {
            this.level.playSound(player, pos, sound, category, volume, pitch);
        }

        public void addParticle(@Nonnull ParticleOptions particleData, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            this.level.addParticle(particleData, x, y, z, xSpeed, ySpeed, zSpeed);
        }

        public void levelEvent(@Nullable Player player, int type, @Nonnull BlockPos pos, int data) {
            this.level.levelEvent(player, type, pos, data);
        }

        public void gameEvent(@NotNull Holder<GameEvent> holder, @NotNull Vec3 vec3, @NotNull GameEvent.Context context) {
            this.level.gameEvent(holder, vec3, context);
        }

        @Nonnull
        public RegistryAccess registryAccess() {
            return this.level.registryAccess();
        }

        @Nonnull
        public FeatureFlagSet enabledFeatures() {
            return this.level.enabledFeatures();
        }

        public float getShade(@Nonnull Direction direction, boolean pShade) {
            return this.level.getShade(direction, pShade);
        }

        @Nonnull
        public LevelLightEngine getLightEngine() {
            return this.level.getLightEngine();
        }

        @Nonnull
        public WorldBorder getWorldBorder() {
            return this.level.getWorldBorder();
        }

        @Nullable
        public synchronized BlockEntity getBlockEntity(@Nonnull BlockPos pos) {
            return this.blockEntityCache.computeIfAbsent(pos, arg_0 -> ((ServerLevel)this.level).getBlockEntity(arg_0));
        }

        @Nonnull
        public BlockState getBlockState(@Nonnull BlockPos pos) {
            return this.level.getBlockState(pos);
        }

        @Nonnull
        public FluidState getFluidState(@Nonnull BlockPos pos) {
            return this.level.getFluidState(pos);
        }

        @Nonnull
        public List<Entity> getEntities(@Nullable Entity entity, @Nonnull AABB area, @Nonnull Predicate<? super Entity> predicate) {
            return this.level.getEntities(entity, area, predicate);
        }

        @Nonnull
        public <T extends Entity> List<T> getEntities(@Nonnull EntityTypeTest<Entity, T> entityTypeTest, @Nonnull AABB area, @Nonnull Predicate<? super T> predicate) {
            return this.level.getEntities(entityTypeTest, area, predicate);
        }

        @Nonnull
        public List<? extends Player> players() {
            return this.level.players();
        }

        @Nullable
        public ChunkAccess getChunk(int i, int i1, @NotNull ChunkStatus chunkStatus, boolean b) {
            return this.level.getChunk(i, i1, chunkStatus, b);
        }

        public int getHeight(@Nonnull Heightmap.Types heightmapType, int pX, int pZ) {
            return this.level.getHeight(heightmapType, pX, pZ);
        }

        public int getSkyDarken() {
            return this.level.getSkyDarken();
        }

        @Nonnull
        public BiomeManager getBiomeManager() {
            return this.level.getBiomeManager();
        }

        @Nonnull
        public Holder<Biome> getUncachedNoiseBiome(int pX, int pY, int pZ) {
            return this.level.getUncachedNoiseBiome(pX, pY, pZ);
        }

        public boolean isClientSide() {
            return this.level.isClientSide();
        }

        public int getSeaLevel() {
            return this.level.getSeaLevel();
        }

        @Nonnull
        public DimensionType dimensionType() {
            return this.level.dimensionType();
        }

        public boolean isStateAtPosition(@Nonnull BlockPos pos, @Nonnull Predicate<BlockState> state) {
            return this.level.isStateAtPosition(pos, state);
        }

        public boolean isFluidAtPosition(@Nonnull BlockPos pos, @Nonnull Predicate<FluidState> predicate) {
            return this.level.isFluidAtPosition(pos, predicate);
        }

        public boolean setBlock(@Nonnull BlockPos pos, @Nonnull BlockState state, int pFlags, int pRecursionLeft) {
            return this.level.setBlock(pos, state, pFlags, pRecursionLeft);
        }

        public boolean removeBlock(@Nonnull BlockPos pos, boolean pIsMoving) {
            return this.level.removeBlock(pos, pIsMoving);
        }

        public boolean destroyBlock(@Nonnull BlockPos pos, boolean pDropBlock, @Nullable Entity pEntity, int pRecursionLeft) {
            return this.level.destroyBlock(pos, pDropBlock, pEntity, pRecursionLeft);
        }
    }
}

