/*
 * Decompiled with CFR 0.152.
 */
package sirttas.dpanvil.api.predicate.block.direction;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelReader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sirttas.dpanvil.api.predicate.block.BlockPosPredicateType;
import sirttas.dpanvil.api.predicate.block.IBlockPosPredicate;

public enum FacingBlockPredicate implements IBlockPosPredicate
{
    DOWN(Direction.DOWN),
    UP(Direction.UP),
    NORTH(Direction.NORTH),
    SOUTH(Direction.SOUTH),
    WEST(Direction.WEST),
    EAST(Direction.EAST);

    public static final String NAME = "facing";
    public static final MapCodec<FacingBlockPredicate> CODEC;
    private final Direction direction;

    private FacingBlockPredicate(Direction direction) {
        this.direction = direction;
    }

    @Override
    public boolean test(@NotNull LevelReader level, @NotNull BlockPos pos, @Nullable Direction direction) {
        return direction == this.direction;
    }

    @Override
    public BlockPosPredicateType<? extends IBlockPosPredicate> getType() {
        return (BlockPosPredicateType)BlockPosPredicateType.FACING.get();
    }

    static {
        CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Direction.CODEC.fieldOf("direction").forGetter(f -> f.direction)).apply((Applicative)builder, d -> switch (d) {
            default -> throw new MatchException(null, null);
            case Direction.DOWN -> DOWN;
            case Direction.UP -> UP;
            case Direction.NORTH -> NORTH;
            case Direction.SOUTH -> SOUTH;
            case Direction.WEST -> WEST;
            case Direction.EAST -> EAST;
        }));
    }
}

