/*
 * Decompiled with CFR 0.152.
 */
package sirttas.dpanvil.api.predicate.block;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import sirttas.dpanvil.api.predicate.block.BlockPosPredicateType;
import sirttas.dpanvil.api.predicate.block.logical.AndBlockPredicate;
import sirttas.dpanvil.api.predicate.block.logical.AnyBlockPredicate;
import sirttas.dpanvil.api.predicate.block.logical.NoneBlockPredicate;
import sirttas.dpanvil.api.predicate.block.logical.NotBlockPredicate;
import sirttas.dpanvil.api.predicate.block.logical.OrBlockPredicate;
import sirttas.dpanvil.api.predicate.block.match.MatchBlockPredicate;
import sirttas.dpanvil.api.predicate.block.match.MatchBlockStatePredicate;
import sirttas.dpanvil.api.predicate.block.match.MatchBlockTagPredicate;
import sirttas.dpanvil.api.predicate.block.match.MatchBlocksPredicate;
import sirttas.dpanvil.api.predicate.block.world.CacheBlockPredicate;
import sirttas.dpanvil.api.predicate.block.world.OffsetBlockPredicate;

public interface IBlockPosPredicate {
    public static final Codec<IBlockPosPredicate> CODEC = BlockPosPredicateType.REGISTRY.byNameCodec().dispatch(IBlockPosPredicate::getType, BlockPosPredicateType::codec);

    public boolean test(@Nonnull LevelReader var1, @Nonnull BlockPos var2, @Nullable Direction var3);

    public BlockPosPredicateType<? extends IBlockPosPredicate> getType();

    default public IBlockPosPredicate or(IBlockPosPredicate ... predicates) {
        ArrayList list = Lists.newArrayList((Object[])predicates);
        list.add(this);
        return new OrBlockPredicate(list);
    }

    default public IBlockPosPredicate and(IBlockPosPredicate ... predicates) {
        ArrayList list = Lists.newArrayList((Object[])predicates);
        list.add(this);
        return new AndBlockPredicate(list);
    }

    default public IBlockPosPredicate not() {
        return new NotBlockPredicate(this);
    }

    default public IBlockPosPredicate offset(Vec3i offset) {
        return new OffsetBlockPredicate(this, offset);
    }

    default public IBlockPosPredicate offset(int x, int y, int z) {
        return this.offset((Vec3i)new BlockPos(x, y, z));
    }

    default public IBlockPosPredicate cache() {
        return new CacheBlockPredicate(this);
    }

    public static IBlockPosPredicate any() {
        return AnyBlockPredicate.get();
    }

    public static IBlockPosPredicate none() {
        return NoneBlockPredicate.get();
    }

    public static IBlockPosPredicate createOr(IBlockPosPredicate ... predicates) {
        return new OrBlockPredicate(predicates);
    }

    public static IBlockPosPredicate createAnd(IBlockPosPredicate ... predicates) {
        return new AndBlockPredicate(predicates);
    }

    public static IBlockPosPredicate match(Block ... blocks) {
        if (blocks.length == 1) {
            return new MatchBlockPredicate(blocks[0]);
        }
        return new MatchBlocksPredicate(blocks);
    }

    public static IBlockPosPredicate match(TagKey<Block> tag) {
        return new MatchBlockTagPredicate(tag);
    }

    public static IBlockPosPredicate match(BlockState state) {
        return new MatchBlockStatePredicate(state);
    }

    default public IBlockPosPredicate simplify() {
        return this;
    }

    @Nonnull
    default public List<Component> getTooltip() {
        return List.of();
    }
}

