/*
 * Decompiled with CFR 0.152.
 */
package sirttas.dpanvil.api.imc;

import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.neoforged.fml.InterModComms;
import sirttas.dpanvil.api.data.IDataManager;

public class DataManagerIMC<T> {
    public static final String METHOD = "data_manager";
    private final IDataManager<T> manager;
    private Codec<T> codec;
    private Function<JsonElement, T> readJson;
    private Function<FriendlyByteBuf, T> readPacket;
    private BiConsumer<FriendlyByteBuf, T> writePacket;

    public DataManagerIMC(IDataManager<T> manager) {
        this.manager = manager;
    }

    public ResourceKey<IDataManager<T>> getKey() {
        return this.manager.getKey();
    }

    public IDataManager<T> getManager() {
        return this.manager;
    }

    public Codec<T> getCodec() {
        return this.codec;
    }

    public Function<JsonElement, T> getReadJson() {
        return this.readJson;
    }

    public Function<FriendlyByteBuf, T> getReadPacket() {
        return this.readPacket;
    }

    public BiConsumer<FriendlyByteBuf, T> getWritePacket() {
        return this.writePacket;
    }

    public DataManagerIMC<T> withCodec(Codec<T> codec) {
        this.codec = codec;
        this.readJson = null;
        this.readPacket = null;
        this.writePacket = null;
        return this;
    }

    public DataManagerIMC<T> withSerializer(Function<JsonElement, T> readJson, Function<FriendlyByteBuf, T> readPacket, BiConsumer<FriendlyByteBuf, T> writePacket) {
        this.codec = null;
        this.readJson = readJson;
        this.readPacket = readPacket;
        this.writePacket = writePacket;
        return this;
    }

    public DataManagerIMC<T> withSerializer(Function<FriendlyByteBuf, T> readPacket, BiConsumer<FriendlyByteBuf, T> writePacket) {
        return this.withSerializer(null, readPacket, writePacket);
    }

    public static <T> void enqueue(Supplier<DataManagerIMC<T>> supplier) {
        InterModComms.sendTo((String)"dpanvil", (String)METHOD, supplier);
    }
}

