/*
 * Decompiled with CFR 0.152.
 */
package sirttas.dpanvil.api.data;

import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Keyable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderOwner;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.jetbrains.annotations.NotNull;
import sirttas.dpanvil.api.DataPackAnvilApi;
import sirttas.dpanvil.api.codec.CodecHelper;

public interface IDataManager<T>
extends PreparableReloadListener,
Codec<T>,
Keyable,
HolderOwner<T> {
    public ResourceKey<IDataManager<T>> getKey();

    @Nonnull
    public Class<T> getContentType();

    @Nonnull
    public String getFolder();

    @Nonnull
    public static <T> ResourceKey<T> createKey(@Nonnull ResourceKey<? super IDataManager<T>> managerKey, @Nonnull ResourceLocation id) {
        return DataPackAnvilApi.createResourceKey(managerKey.location(), id);
    }

    @Nonnull
    public static <T> ResourceKey<IDataManager<T>> createManagerKey(@Nonnull ResourceLocation pLocation) {
        return DataPackAnvilApi.createResourceKey(DataPackAnvilApi.DATA_MANAGER_ROOT, pLocation);
    }

    @Nonnull
    public static <T> Codec<ResourceKey<T>> keyCodec(@Nonnull ResourceKey<? super IDataManager<T>> managerKey) {
        return ResourceLocation.CODEC.xmap(l -> IDataManager.createKey(managerKey, l), ResourceKey::location);
    }

    @Nonnull
    public Map<ResourceLocation, T> getData();

    public void setData(@Nonnull Map<ResourceLocation, T> var1);

    @Nonnull
    default public Holder<T> getOrCreateHolder(@Nonnull ResourceKey<T> key) {
        return this.getOrCreateHolder(key.location());
    }

    @Nonnull
    default public Holder<T> getOrCreateHolder(@Nonnull ResourceLocation key) {
        return Holder.direct(this.get(key));
    }

    default public Stream<Holder<T>> holders() {
        return this.getData().keySet().stream().map(this::getOrCreateHolder).filter(Holder::isBound);
    }

    @Nullable
    default public T get(@Nonnull ResourceKey<T> key) {
        return this.getData().get(key.location());
    }

    @Nullable
    default public T get(@Nonnull ResourceLocation id) {
        return this.getData().get(id);
    }

    @Nullable
    default public T getOrDefault(@Nonnull ResourceLocation id, @Nullable T defaultValue) {
        return this.getData().getOrDefault(id, defaultValue);
    }

    @Nonnull
    default public Optional<T> getOptional(@Nonnull ResourceLocation id) {
        return Optional.ofNullable(this.get(id));
    }

    @Nonnull
    default public ResourceLocation getId(@Nullable T value) {
        return this.getData().entrySet().stream().filter(e -> e.getValue().equals(value)).map(Map.Entry::getKey).findAny().orElse(DataPackAnvilApi.ID_NONE);
    }

    @NotNull
    default public ResourceLocation getId(Holder<T> holder) {
        if (holder instanceof Holder.Reference) {
            Holder.Reference r = (Holder.Reference)holder;
            return r.key().location();
        }
        return this.getId(holder.value());
    }

    @Nonnull
    default public List<T> getAll(@Nonnull Collection<ResourceLocation> ids) {
        return ids.stream().map(this::get).filter(Objects::nonNull).toList();
    }

    default public boolean hasId(@Nonnull ResourceLocation id) {
        return this.getData().containsKey(id);
    }

    default public boolean has(@Nonnull T value) {
        return this.getData().containsValue(value);
    }

    default public <U> DataResult<Pair<T, U>> decode(DynamicOps<U> ops, U input) {
        return ResourceLocation.CODEC.decode(ops, input).map(pair -> pair.mapFirst(this::get));
    }

    default public <U> DataResult<U> encode(T input, DynamicOps<U> ops, U prefix) {
        return ResourceLocation.CODEC.encode((Object)this.getId(input), ops, prefix);
    }

    default public <U> Stream<U> keys(DynamicOps<U> dynOps) {
        return this.getData().keySet().stream().map(id -> dynOps.createString(id.toString()));
    }

    @Nonnull
    default public DeferredHolder<DataComponentType<?>, DataComponentType<Holder<T>>> registerComponentType(@Nonnull DeferredRegister<DataComponentType<?>> deferredRegister) {
        ResourceLocation location;
        String managerNamespace;
        String registryNamespace = deferredRegister.getNamespace();
        if (!registryNamespace.equals(managerNamespace = (location = this.getKey().location()).getNamespace())) {
            throw new IllegalArgumentException("The deferred register namespace (" + registryNamespace + ") must be the same as the manager namespace (" + managerNamespace + ").");
        }
        return deferredRegister.register(location.getPath(), () -> DataComponentType.builder().persistent(ResourceLocation.CODEC.xmap(this::getOrCreateHolder, this::getId)).networkSynchronized(ResourceLocation.STREAM_CODEC.map(this::getOrCreateHolder, this::getId)).cacheEncoding().build());
    }

    @Nonnull
    public static <T> Builder<T> builder(@Nonnull Class<T> type, @Nonnull ResourceKey<IDataManager<T>> key) {
        return DataPackAnvilApi.service().createDataManagerBuilder(type, key);
    }

    public static interface Builder<T> {
        public Builder<T> withIdSetter(BiConsumer<T, ResourceLocation> var1);

        default public Builder<T> withDefault(T defaultValue) {
            return this.withDefault(id -> defaultValue);
        }

        public Builder<T> folder(String var1);

        public Builder<T> withDefault(Function<ResourceLocation, T> var1);

        public Builder<T> withInheritance();

        public <R> Builder<T> merged(Function<Stream<R>, T> var1, Function<JsonElement, R> var2);

        default public <R> Builder<T> merged(Function<Stream<R>, T> merger, Decoder<R> rawDecoder) {
            return this.merged(merger, (JsonElement json) -> CodecHelper.decode(rawDecoder, json));
        }

        default public Builder<T> merged(Function<Stream<T>, T> merger) {
            return this.merged(merger, (Function)null);
        }

        public IDataManager<T> build();
    }
}

