/*
 * Decompiled with CFR 0.152.
 */
package sirttas.dpanvil.api.data;

import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import sirttas.dpanvil.api.codec.CodecHelper;
import sirttas.dpanvil.api.data.AbstractManagedDataProvider;
import sirttas.dpanvil.api.data.IDataManager;

public abstract class AbstractManagedDataBuilderProvider<T, B>
extends AbstractManagedDataProvider<T> {
    private final BiFunction<B, DynamicOps<JsonElement>, JsonElement> builder;
    private final Map<ResourceLocation, B> data;
    private HolderLookup.Provider resolvedRegistries;

    protected AbstractManagedDataBuilderProvider(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> registries, IDataManager<T> manager, Encoder<B> encoder) {
        this(packOutput, registries, manager, (B b, DynamicOps<JsonElement> o) -> (JsonElement)CodecHelper.encode(encoder, o, b));
    }

    protected AbstractManagedDataBuilderProvider(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> registries, IDataManager<T> manager, BiFunction<B, DynamicOps<JsonElement>, JsonElement> builder) {
        super(packOutput, registries, manager);
        this.builder = builder;
        this.data = new HashMap<ResourceLocation, B>();
    }

    @Nonnull
    public CompletableFuture<?> run(@Nonnull CachedOutput cache) {
        return this.registries.thenCompose(r -> {
            this.resolvedRegistries = r;
            this.collectBuilders(this.resolvedRegistries);
            ArrayList list = new ArrayList(this.data.size());
            RegistryOps ops = this.resolvedRegistries.createSerializationContext((DynamicOps)JsonOps.INSTANCE);
            for (Map.Entry<ResourceLocation, B> entry : this.data.entrySet()) {
                list.add(this.save(cache, (DynamicOps<JsonElement>)ops, entry.getValue(), entry.getKey()));
            }
            this.data.clear();
            return CompletableFuture.allOf((CompletableFuture[])list.toArray(CompletableFuture[]::new));
        });
    }

    protected abstract void collectBuilders(HolderLookup.Provider var1);

    protected B add(ResourceKey<T> key, B element) {
        return this.add(key.location(), element);
    }

    protected B add(ResourceLocation id, B element) {
        return (B)this.data.compute(id, (k, v) -> {
            if (v != null) {
                throw new IllegalStateException("Duplicate id: " + String.valueOf(id) + ", manager: " + String.valueOf(this.manager));
            }
            return element;
        });
    }

    protected CompletableFuture<?> save(CachedOutput cache, DynamicOps<JsonElement> ops, B element, ResourceKey<T> key) {
        return this.save(cache, ops, element, key.location());
    }

    protected CompletableFuture<?> save(CachedOutput cache, DynamicOps<JsonElement> ops, B element, ResourceLocation id) {
        try {
            return this.save(cache, this.builder.apply(element, ops), id);
        }
        catch (Exception e) {
            throw new IllegalStateException("Error saving data: " + String.valueOf(id) + ", manager: " + String.valueOf(this.manager), e);
        }
    }

    @Nonnull
    protected <U> HolderLookup.RegistryLookup<U> getRegistry(ResourceKey<? extends Registry<U>> registry) {
        return this.resolvedRegistries.lookupOrThrow(registry);
    }

    public <U> HolderSet.Named<U> createHolderSet(TagKey<U> tag) {
        return this.getRegistry(tag.registry()).getOrThrow(tag);
    }
}

