/*
 * Decompiled with CFR 0.152.
 */
package sirttas.dpanvil;

import net.minecraft.core.RegistryAccess;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.InterModProcessEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.AddReloadListenerEvent;
import net.neoforged.neoforge.event.OnDatapackSyncEvent;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import sirttas.dpanvil.api.DataPackAnvilApi;
import sirttas.dpanvil.api.data.remap.RemapKeys;
import sirttas.dpanvil.api.event.DataPackReloadCompleteEvent;
import sirttas.dpanvil.api.imc.DataManagerIMC;
import sirttas.dpanvil.api.predicate.block.BlockPosPredicateType;
import sirttas.dpanvil.data.DataManagerWrapper;
import sirttas.dpanvil.data.network.payload.DPAnvilPacketDistributor;
import sirttas.dpanvil.data.network.payload.ReloadDataPayload;

@Mod(value="dpanvil")
public class DataPackAnvil {
    public static final DataManagerWrapper WRAPPER = new DataManagerWrapper();

    public DataPackAnvil(IEventBus modBus) {
        BlockPosPredicateType.register(modBus);
        modBus.addListener(this::processIMC);
        NeoForge.EVENT_BUS.addListener(EventPriority.LOWEST, this::serverStarted);
        NeoForge.EVENT_BUS.addListener(this::syncDataManagers);
        NeoForge.EVENT_BUS.addListener(this::addReloadListeners);
        DataPackAnvilApi.service();
    }

    private void serverStarted(ServerStartedEvent event) {
        DataPackAnvil.onReloadCompleted(event.getServer());
    }

    private void processIMC(InterModProcessEvent event) {
        WRAPPER.putManagerFromIMC(() -> new DataManagerIMC<RemapKeys>(DataPackAnvilApi.REMAP_KEYS_MANAGER).withCodec(RemapKeys.CODEC));
        event.getIMCStream("data_manager"::equals).forEach(message -> WRAPPER.putManagerFromIMC(message.messageSupplier()));
    }

    private void syncDataManagers(OnDatapackSyncEvent event) {
        if (event.getPlayer() != null) {
            return;
        }
        DPAnvilPacketDistributor.sendToAllRemotePlayers(new ReloadDataPayload(WRAPPER.ids()), new CustomPacketPayload[0]);
        DataPackAnvil.onReloadCompleted(event.getPlayerList().getServer());
    }

    private static void onReloadCompleted(MinecraftServer server) {
        NeoForge.EVENT_BUS.post((Event)new DataPackReloadCompleteEvent(server.getRecipeManager(), WRAPPER.getDataManagers(), (RegistryAccess)server.registryAccess()));
    }

    private void addReloadListeners(AddReloadListenerEvent event) {
        if (!WRAPPER.getDataManagers().isEmpty()) {
            event.addListener((PreparableReloadListener)WRAPPER);
        }
    }
}

