/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.items.tools;

import de.ellpeck.naturesaura.reg.IModItem;
import de.ellpeck.naturesaura.reg.ModArmorMaterial;
import de.ellpeck.naturesaura.reg.ModRegistry;
import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.phys.AABB;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

public class ItemArmor
extends ArmorItem
implements IModItem {
    private static final AttributeModifier SKY_MOVEMENT_MODIFIER = new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"naturesaura", (String)"sky_movement_speed"), (double)0.15f, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
    private static final AttributeModifier SKY_STEP_MODIFIER = new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"naturesaura", (String)"sky_step_modifier"), 0.5, AttributeModifier.Operation.ADD_VALUE);
    private static final Map<ArmorMaterial, Item[]> SETS = new ConcurrentHashMap<ArmorMaterial, Item[]>();
    private final String baseName;

    public ItemArmor(String baseName, ModArmorMaterial materialIn, ArmorItem.Type equipmentSlotIn) {
        super(materialIn.material, equipmentSlotIn, new Item.Properties().durability(materialIn.getDurability(equipmentSlotIn)));
        this.baseName = baseName;
        ModRegistry.ALL_ITEMS.add(this);
    }

    public static boolean isFullSetEquipped(LivingEntity entity, ArmorMaterial material) {
        Item[] set = SETS.computeIfAbsent(material, m -> (Item[])BuiltInRegistries.ITEM.stream().filter(i -> i instanceof ItemArmor && ((ItemArmor)i).getMaterial().value() == material).sorted(Comparator.comparingInt(i -> ((ItemArmor)i).getEquipmentSlot().ordinal())).toArray(Item[]::new));
        for (int i = 0; i < 4; ++i) {
            EquipmentSlot slot = EquipmentSlot.values()[i + 2];
            ItemStack stack = entity.getItemBySlot(slot);
            if (stack.getItem() == set[i] || slot == EquipmentSlot.CHEST && stack.getItem() == Items.ELYTRA) continue;
            return false;
        }
        return true;
    }

    @Override
    public String getBaseName() {
        return this.baseName;
    }

    @EventBusSubscriber
    private static final class EventHandler {
        private EventHandler() {
        }

        @SubscribeEvent
        public static void onAttack(LivingIncomingDamageEvent event) {
            LivingEntity entity = event.getEntity();
            if (!entity.level().isClientSide) {
                if (ItemArmor.isFullSetEquipped(entity, (ArmorMaterial)ModArmorMaterial.INFUSED.material.value())) {
                    Entity source = event.getSource().getEntity();
                    if (source instanceof LivingEntity) {
                        ((LivingEntity)source).addEffect(new MobEffectInstance(MobEffects.WITHER, 40));
                    }
                } else if (ItemArmor.isFullSetEquipped(entity, (ArmorMaterial)ModArmorMaterial.DEPTH.material.value())) {
                    for (LivingEntity other : entity.level().getEntitiesOfClass(LivingEntity.class, new AABB(entity.position(), entity.position()).inflate(2.0))) {
                        Player player;
                        if (other == entity || entity instanceof Player && (player = (Player)entity).isAlliedTo((Entity)other)) continue;
                        other.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 60, 255));
                    }
                }
            }
        }

        @SubscribeEvent
        public static void update(PlayerTickEvent.Post event) {
            Player player = event.getEntity();
            AttributeInstance speed = player.getAttribute(Attributes.MOVEMENT_SPEED);
            AttributeInstance step = player.getAttribute(Attributes.STEP_HEIGHT);
            String key = "naturesaura:sky_equipped";
            CompoundTag nbt = player.getPersistentData();
            boolean equipped = ItemArmor.isFullSetEquipped((LivingEntity)player, (ArmorMaterial)ModArmorMaterial.SKY.material.value());
            if (equipped && !nbt.getBoolean(key)) {
                nbt.putBoolean(key, true);
                if (!step.hasModifier(SKY_STEP_MODIFIER.id())) {
                    step.addPermanentModifier(SKY_STEP_MODIFIER);
                }
                if (!speed.hasModifier(SKY_MOVEMENT_MODIFIER.id())) {
                    speed.addPermanentModifier(SKY_MOVEMENT_MODIFIER);
                }
            } else if (!equipped && nbt.getBoolean(key)) {
                nbt.putBoolean(key, false);
                step.removeModifier(SKY_STEP_MODIFIER.id());
                speed.removeModifier(SKY_MOVEMENT_MODIFIER.id());
            }
        }
    }
}

