/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.items;

import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.items.ItemImpl;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class ItemNetheriteFinder
extends ItemImpl {
    public ItemNetheriteFinder() {
        super("netherite_finder", new Item.Properties().stacksTo(1));
    }

    public InteractionResultHolder<ItemStack> use(Level levelIn, Player playerIn, InteractionHand handIn) {
        ItemStack stack = playerIn.getItemInHand(handIn);
        NaturesAuraAPI.IInternalHooks inst = NaturesAuraAPI.instance();
        if (!inst.extractAuraFromPlayer(playerIn, 200000, false)) {
            return new InteractionResultHolder(InteractionResult.FAIL, (Object)stack);
        }
        if (levelIn.isClientSide) {
            inst.setParticleDepth(false);
            inst.setParticleSpawnRange(64);
            inst.setParticleCulling(false);
            BlockPos pos = playerIn.blockPosition();
            int range = 12;
            for (int x = -range; x <= range; ++x) {
                for (int y = 0; y <= 128; ++y) {
                    for (int z = -range; z <= range; ++z) {
                        BlockPos offset = new BlockPos(pos.getX() + x, y, pos.getZ() + z);
                        BlockState state = levelIn.getBlockState(offset);
                        if (state.getBlock() != Blocks.ANCIENT_DEBRIS && !BuiltInRegistries.BLOCK.getKey((Object)state.getBlock()).toString().contains("netherite")) continue;
                        inst.spawnMagicParticle((float)offset.getX() + 0.5f, (float)offset.getY() + 0.5f, (float)offset.getZ() + 0.5f, 0.0, 0.0, 0.0, 11226424, 6.0f, 1200, 0.0f, false, true);
                    }
                }
            }
            inst.setParticleDepth(true);
            inst.setParticleSpawnRange(32);
            inst.setParticleCulling(true);
            playerIn.swing(handIn);
        }
        playerIn.getCooldowns().addCooldown((Item)this, 1200);
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }
}

