/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.items;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.api.multiblock.IMultiblock;
import de.ellpeck.naturesaura.items.ItemImpl;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;

public class ItemMultiblockMaker
extends ItemImpl {
    private static List<IMultiblock> multiblocks;

    public ItemMultiblockMaker() {
        super("multiblock_maker", new Item.Properties().component(Data.TYPE, (Object)new Data(0)));
    }

    public InteractionResultHolder<ItemStack> use(Level levelIn, Player playerIn, InteractionHand handIn) {
        ItemStack stack = playerIn.getItemInHand(handIn);
        if (!levelIn.isClientSide && playerIn.isCreative()) {
            int curr = ItemMultiblockMaker.getMultiblockId(stack);
            int next = (curr + 1) % ItemMultiblockMaker.multiblocks().size();
            stack.set(Data.TYPE, (Object)new Data(next));
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    public InteractionResult useOn(UseOnContext context) {
        Player player = context.getPlayer();
        if (player.isCreative()) {
            IMultiblock multi = ItemMultiblockMaker.getMultiblock(player.getItemInHand(context.getHand()));
            if (multi == null) {
                return InteractionResult.PASS;
            }
            if (!context.getLevel().isClientSide) {
                multi.forEach(context.getClickedPos().above(), '\u0000', (blockPos, matcher) -> {
                    context.getLevel().setBlockAndUpdate(blockPos, matcher.defaultState());
                    return true;
                });
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public Component getName(ItemStack stack) {
        MutableComponent name = (MutableComponent)super.getName(stack);
        IMultiblock multi = ItemMultiblockMaker.getMultiblock(stack);
        return multi == null ? name : name.append(" (" + String.valueOf(multi.getName()) + ")");
    }

    private static List<IMultiblock> multiblocks() {
        if (multiblocks == null) {
            if (NaturesAuraAPI.MULTIBLOCKS.isEmpty()) {
                return null;
            }
            multiblocks = new ArrayList<IMultiblock>();
            multiblocks.addAll(NaturesAuraAPI.MULTIBLOCKS.values());
        }
        return multiblocks;
    }

    private static int getMultiblockId(ItemStack stack) {
        return ((Data)stack.get(Data.TYPE)).multiblockId();
    }

    private static IMultiblock getMultiblock(ItemStack stack) {
        List<IMultiblock> multiblocks = ItemMultiblockMaker.multiblocks();
        if (multiblocks == null) {
            return null;
        }
        int id = ItemMultiblockMaker.getMultiblockId(stack);
        if (id < 0 || id >= multiblocks.size()) {
            return null;
        }
        return multiblocks.get(id);
    }

    public record Data(int multiblockId) {
        public static final Codec<Data> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.INT.fieldOf("multiblock_id").forGetter(d -> d.multiblockId)).apply((Applicative)i, Data::new));
        public static final DataComponentType<Data> TYPE = DataComponentType.builder().persistent(CODEC).cacheEncoding().build();
    }
}

