/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.data;

import de.ellpeck.naturesaura.compat.Compat;
import de.ellpeck.naturesaura.data.BiomeModifiers;
import de.ellpeck.naturesaura.data.BlockLootProvider;
import de.ellpeck.naturesaura.data.BlockStateGenerator;
import de.ellpeck.naturesaura.data.BlockTagProvider;
import de.ellpeck.naturesaura.data.ItemModelGenerator;
import de.ellpeck.naturesaura.data.ItemTagProvider;
import de.ellpeck.naturesaura.gen.ModFeatures;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.Cloner;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.data.registries.VanillaRegistries;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.DatapackBuiltinEntriesProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.registries.DataPackRegistriesHooks;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public final class ModData {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        PackOutput out = gen.getPackOutput();
        CompletableFuture lookup = event.getLookupProvider();
        ExistingFileHelper existing = event.getExistingFileHelper();
        Compat.gatherData(event);
        BlockTagProvider blockTags = new BlockTagProvider(out, lookup, existing);
        gen.addProvider(event.includeServer(), (DataProvider)blockTags);
        gen.addProvider(event.includeServer(), (DataProvider)new ItemTagProvider(out, lookup, blockTags.contentsGetter(), existing));
        gen.addProvider(event.includeServer(), (DataProvider)new LootTableProvider(out, Set.of(), List.of(new LootTableProvider.SubProviderEntry(BlockLootProvider::new, LootContextParamSets.BLOCK)), lookup));
        gen.addProvider(event.includeServer(), (DataProvider)new BlockStateGenerator(out, existing));
        gen.addProvider(event.includeServer(), (DataProvider)new ItemModelGenerator(out, existing));
        gen.addProvider(event.includeServer(), (DataProvider)new DatapackBuiltinEntriesProvider(out, CompletableFuture.supplyAsync(ModData::getProvider), Set.of("naturesaura")));
    }

    private static RegistrySetBuilder.PatchedRegistries getProvider() {
        RegistrySetBuilder registryBuilder = new RegistrySetBuilder();
        registryBuilder.add(Registries.CONFIGURED_FEATURE, ModFeatures.Configured::bootstrap);
        registryBuilder.add(Registries.PLACED_FEATURE, ModFeatures.Placed::bootstrap);
        registryBuilder.add(NeoForgeRegistries.Keys.BIOME_MODIFIERS, BiomeModifiers::bootstrap);
        registryBuilder.add(Registries.BIOME, context -> {});
        Cloner.Factory factory = new Cloner.Factory();
        DataPackRegistriesHooks.getDataPackRegistriesWithDimensions().forEach(data -> data.runWithArguments((arg_0, arg_1) -> ((Cloner.Factory)factory).addCodec(arg_0, arg_1)));
        return registryBuilder.buildPatch((RegistryAccess)RegistryAccess.fromRegistryOfRegistries((Registry)BuiltInRegistries.REGISTRY), VanillaRegistries.createLookup(), factory);
    }
}

