/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks.tiles;

import de.ellpeck.naturesaura.blocks.tiles.BlockEntityImpl;
import de.ellpeck.naturesaura.blocks.tiles.ITickableBlockEntity;
import de.ellpeck.naturesaura.blocks.tiles.ModBlockEntities;
import de.ellpeck.naturesaura.packet.PacketHandler;
import de.ellpeck.naturesaura.packet.PacketParticles;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.monster.MagmaCube;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.level.block.state.BlockState;

public class BlockEntitySlimeSplitGenerator
extends BlockEntityImpl
implements ITickableBlockEntity {
    private int generationTimer;
    private int amountToRelease;
    private int color;

    public BlockEntitySlimeSplitGenerator(BlockPos pos, BlockState state) {
        super(ModBlockEntities.SLIME_SPLIT_GENERATOR, pos, state);
    }

    @Override
    public void tick() {
        if (this.level.isClientSide || this.level.getGameTime() % 10L != 0L) {
            return;
        }
        if (this.generationTimer > 0) {
            int amount = this.amountToRelease * 10;
            if (this.canGenerateRightNow(amount)) {
                this.generateAura(amount);
                PacketHandler.sendToAllAround(this.level, this.worldPosition, 32, new PacketParticles((float)this.worldPosition.getX(), (float)this.worldPosition.getY(), (float)this.worldPosition.getZ(), PacketParticles.Type.SLIME_SPLIT_GEN_CREATE, this.color));
            }
            this.generationTimer -= 10;
        }
    }

    @Override
    public boolean wantsLimitRemover() {
        return true;
    }

    public boolean isBusy() {
        return this.generationTimer > 0;
    }

    public void startGenerating(Slime slime) {
        int size = slime.getSize();
        this.generationTimer = size * 30;
        this.amountToRelease = size * this.getGenerationAmount(slime) / this.generationTimer;
        this.color = this.getSlimeColor(slime);
        PacketHandler.sendToAllAround(this.level, this.worldPosition, 32, new PacketParticles((float)slime.getX(), (float)slime.getY(), (float)slime.getZ(), PacketParticles.Type.SLIME_SPLIT_GEN_START, this.worldPosition.getX(), this.worldPosition.getY(), this.worldPosition.getZ(), this.color));
    }

    @Override
    public void writeNBT(CompoundTag compound, BlockEntityImpl.SaveType type, HolderLookup.Provider registries) {
        super.writeNBT(compound, type, registries);
        if (type == BlockEntityImpl.SaveType.TILE) {
            compound.putInt("timer", this.generationTimer);
            compound.putInt("amount", this.amountToRelease);
            compound.putInt("color", this.color);
        }
    }

    @Override
    public void readNBT(CompoundTag compound, BlockEntityImpl.SaveType type, HolderLookup.Provider registries) {
        super.readNBT(compound, type, registries);
        if (type == BlockEntityImpl.SaveType.TILE) {
            this.generationTimer = compound.getInt("timer");
            this.amountToRelease = compound.getInt("amount");
            this.color = compound.getInt("color");
        }
    }

    private int getSlimeColor(Slime slime) {
        if (slime instanceof MagmaCube) {
            return 9708822;
        }
        return 5089359;
    }

    private int getGenerationAmount(Slime slime) {
        if (slime instanceof MagmaCube) {
            return 45000;
        }
        return 25000;
    }
}

