/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.chromacarvings.registry;

import cy.jdkdigital.chromacarvings.common.block.ColoredCarvedPumpkinBlock;
import cy.jdkdigital.chromacarvings.common.block.ColoredEquipableCarvedPumpkinBlock;
import cy.jdkdigital.chromacarvings.common.block.ColoredPumpkinBlock;
import cy.jdkdigital.chromacarvings.common.entity.ColoredSnowGolem;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class Registrator {
    public static final DeferredRegister<EntityType<?>> ENTITIES = DeferredRegister.create((Registry)BuiltInRegistries.ENTITY_TYPE, (String)"chromacarvings");
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((Registry)BuiltInRegistries.BLOCK, (String)"chromacarvings");
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((Registry)BuiltInRegistries.ITEM, (String)"chromacarvings");
    public static final Map<DyeColor, DeferredHolder<EntityType<?>, EntityType<ColoredSnowGolem>>> SNOW_GOLEMS = Registrator.createDyedEntities("snow_golem", EntityType.Builder.of(ColoredSnowGolem::new, (MobCategory)MobCategory.MISC).immuneTo(new Block[]{Blocks.POWDER_SNOW}).sized(0.7f, 1.9f).eyeHeight(1.7f).clientTrackingRange(8));
    public static final Map<DyeColor, DeferredHolder<Block, Block>> PUMPKINS = Registrator.createDyedBlocks("pumpkin", () -> new ColoredPumpkinBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.PUMPKIN)));
    public static final Map<DyeColor, DeferredHolder<Block, Block>> CARVED_PUMPKINS = Registrator.createDyedBlocks("carved_pumpkin", () -> new ColoredEquipableCarvedPumpkinBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CARVED_PUMPKIN)));
    public static final Map<DyeColor, DeferredHolder<Block, Block>> JACKOS = Registrator.createDyedBlocks("jack_o_lantern", () -> new ColoredCarvedPumpkinBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.JACK_O_LANTERN)));

    public static void register() {
    }

    public static <E extends Entity> Map<DyeColor, DeferredHolder<EntityType<?>, EntityType<E>>> createDyedEntities(String name, EntityType.Builder<E> builder) {
        HashMap entities = new HashMap();
        for (DyeColor color : DyeColor.values()) {
            entities.put(color, Registrator.createEntity(color.getSerializedName() + "_" + name, builder));
        }
        return entities;
    }

    public static <E extends Entity> DeferredHolder<EntityType<?>, EntityType<E>> createEntity(String name, EntityType.Builder<E> builder) {
        DeferredHolder entity = ENTITIES.register(name, () -> builder.build("chromacarvings:" + name));
        return entity;
    }

    public static Map<DyeColor, DeferredHolder<Block, Block>> createDyedBlocks(String name, Supplier<Block> supplier) {
        HashMap<DyeColor, DeferredHolder<Block, Block>> blocks = new HashMap<DyeColor, DeferredHolder<Block, Block>>();
        for (DyeColor color : DyeColor.values()) {
            DeferredHolder block = BLOCKS.register(color.getSerializedName() + "_" + name, supplier);
            Registrator.createItem(color.getSerializedName() + "_" + name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
            blocks.put(color, (DeferredHolder<Block, Block>)block);
        }
        return blocks;
    }

    public static DeferredHolder<Item, Item> createItem(String name, Supplier<Item> supplier) {
        return ITEMS.register(name, supplier);
    }
}

