/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.chromacarvings.datagen;

import cy.jdkdigital.chromacarvings.datagen.BlockModelProvider;
import cy.jdkdigital.chromacarvings.datagen.BlockTagProvider;
import cy.jdkdigital.chromacarvings.datagen.ItemTagProvider;
import cy.jdkdigital.chromacarvings.datagen.LanguageProvider;
import cy.jdkdigital.chromacarvings.datagen.LootDataProvider;
import cy.jdkdigital.chromacarvings.datagen.RecipeProvider;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(modid="chromacarvings", bus=EventBusSubscriber.Bus.MOD)
public class ChromaCarvingsDataProvider {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        if (event.getModContainer().getModId().equals("chromacarvings")) {
            Data.gatherData(event);
        }
    }

    static class Data {
        Data() {
        }

        private static void gatherData(GatherDataEvent event) {
            DataGenerator gen = event.getGenerator();
            PackOutput output = event.getGenerator().getPackOutput();
            CompletableFuture provider = event.getLookupProvider();
            ExistingFileHelper helper = event.getExistingFileHelper();
            gen.addProvider(event.includeClient(), (DataProvider)new LanguageProvider(output, "en_us"));
            gen.addProvider(event.includeClient(), (DataProvider)new BlockModelProvider(output));
            gen.addProvider(event.includeServer(), (DataProvider)new LootDataProvider(output, List.of(new LootTableProvider.SubProviderEntry(LootDataProvider.LootProvider::new, LootContextParamSets.BLOCK)), provider));
            gen.addProvider(event.includeServer(), (DataProvider)new RecipeProvider(output, provider));
            BlockTagProvider blockTags = new BlockTagProvider(output, provider, helper);
            gen.addProvider(event.includeServer(), (DataProvider)blockTags);
            gen.addProvider(event.includeServer(), (DataProvider)new ItemTagProvider(output, provider, blockTags.contentsGetter(), helper));
        }
    }
}

