/*
 * Decompiled with CFR 0.152.
 */
package com.zeroregard.ars_technica.mixin;

import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.simibubi.create.content.schematics.cannon.SchematicannonBlockEntity;
import com.zeroregard.ars_technica.ArsTechnica;
import com.zeroregard.ars_technica.Config;
import com.zeroregard.ars_technica.api.ITechnomancerAware;
import com.zeroregard.ars_technica.armor.TechnomancerArmor;
import com.zeroregard.ars_technica.helpers.CurioHelper;
import com.zeroregard.ars_technica.network.ParticleEffectPacket;
import com.zeroregard.ars_technica.network.TechnomancerNearbyPacket;
import com.zeroregard.ars_technica.registry.ParticleRegistry;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={SchematicannonBlockEntity.class})
public class SchematicannonMixin
implements ITechnomancerAware {
    @Shadow(remap=false)
    private int printerCooldown;
    @Shadow(remap=false)
    public SchematicannonBlockEntity.State state;
    private boolean technomancerNearby = false;

    @Inject(method={"tick"}, at={@At(value="TAIL")}, remap=false)
    public void modifyCooldownEveryTick(CallbackInfo ci) {
        if (!((Boolean)Config.Common.SCHEMATIC_CANNON_SPEED_BOOST_ENABLED.get()).booleanValue()) {
            return;
        }
        SchematicannonBlockEntity entity = (SchematicannonBlockEntity)this;
        double range = (Double)Config.Common.SCHEMATIC_CANNON_SPEED_BOOST_RANGE.get();
        AABB aabb = new AABB(entity.getBlockPos()).inflate(range);
        Level world = entity.getLevel();
        List nearbyPlayers = world.getEntitiesOfClass(ServerPlayer.class, aabb);
        boolean foundTechnomancer = nearbyPlayers.stream().anyMatch(player -> TechnomancerArmor.isWearingFullSet((LivingEntity)player) || CurioHelper.hasTaggedCurio(player, ArsTechnica.prefix("technomancer_perk")));
        this.setTechnomancerNearby(foundTechnomancer);
        if (!world.isClientSide()) {
            TechnomancerNearbyPacket packet = new TechnomancerNearbyPacket(foundTechnomancer, entity.getBlockPos());
            Networking.sendToNearbyClient((Level)world, (BlockPos)entity.getBlockPos(), (CustomPacketPayload)packet);
        }
        if (this.state != SchematicannonBlockEntity.State.RUNNING) {
            return;
        }
        if (foundTechnomancer) {
            boolean subtractCooldown;
            boolean bl = subtractCooldown = world.getGameTime() % 2L == 0L;
            if (this.printerCooldown > 0 && subtractCooldown) {
                --this.printerCooldown;
            }
        }
    }

    private void sendBoostParticles(SchematicannonBlockEntity entity, Level world) {
        ParticleEffectPacket.send(world, ParticleColor.fromInt((int)ParticleColor.PURPLE.getColor()), (ParticleType)ParticleRegistry.SPIRAL_DUST_TYPE.get(), entity.getBlockPos().getCenter());
    }

    @Override
    public boolean isTechnomancerNearby() {
        return this.technomancerNearby;
    }

    @Override
    public void setTechnomancerNearby(boolean value) {
        this.technomancerNearby = value;
    }
}

