/*
 * Decompiled with CFR 0.152.
 */
package com.zeroregard.ars_technica.glyphs;

import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.spell.SpellTier;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAOE;
import com.zeroregard.ars_technica.ArsTechnica;
import com.zeroregard.ars_technica.entity.ArcanePressEntity;
import com.zeroregard.ars_technica.glyphs.AbstractItemResolveEffect;
import com.zeroregard.ars_technica.helpers.RecipeHelpers;
import com.zeroregard.ars_technica.helpers.SpellResolverHelpers;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.util.Color;

public class EffectPress
extends AbstractItemResolveEffect {
    public static EffectPress INSTANCE = new EffectPress(ArsTechnica.prefix("glyph_press"), "Press");
    private static float DEFAULT_SPEED = 4.0f;

    private EffectPress(ResourceLocation resourceLocation, String description) {
        super(resourceLocation, description);
    }

    @Override
    public void onResolveEntities(List<ItemEntity> entityList, BlockPos pos, Vec3 posVec, Level world, @Nullable LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        ItemEntity closest;
        ArrayList<ItemEntity> validPressableEntities = new ArrayList<ItemEntity>();
        for (ItemEntity itemEntity : entityList) {
            ItemStack itemStack = itemEntity.getItem();
            Optional<RecipeHolder<Recipe<SingleRecipeInput>>> pressingRecipe = RecipeHelpers.getPressingRecipeForItemStack(itemStack, world);
            if (!pressingRecipe.isPresent()) continue;
            validPressableEntities.add(itemEntity);
        }
        boolean hasFocus = SpellResolverHelpers.hasTransmutationFocus(resolver);
        int aoeBuff = (int)Math.round(spellStats.getAoeMultiplier());
        int maxAmountToPress = Math.round(4 * (1 + aoeBuff)) * (hasFocus ? 2 : 1);
        float speed = hasFocus ? DEFAULT_SPEED * 2.5f : DEFAULT_SPEED;
        Color color = new Color(spellContext.getColors().getColor());
        if (!validPressableEntities.isEmpty() && (closest = (ItemEntity)validPressableEntities.stream().min(Comparator.comparingDouble(e -> e.position().distanceTo(posVec))).orElse(null)) != null) {
            ArcanePressEntity arcanePressEntity = new ArcanePressEntity(closest.position().add(0.0, 1.0, 0.0), world, maxAmountToPress, speed, color, validPressableEntities);
            world.addFreshEntity((Entity)arcanePressEntity);
        }
    }

    public int getDefaultManaCost() {
        return 100;
    }

    public void addAugmentDescriptions(Map<AbstractAugment, String> map) {
        super.addAugmentDescriptions(map);
        map.put((AbstractAugment)AugmentAOE.INSTANCE, "Increases the amount of items processed");
    }

    @Nonnull
    public Set<AbstractAugment> getCompatibleAugments() {
        return this.augmentSetOf(new AbstractAugment[]{AugmentAOE.INSTANCE});
    }

    @Nonnull
    public Set<SpellSchool> getSchools() {
        return this.setOf(new SpellSchool[]{SpellSchools.MANIPULATION});
    }

    public String getBookDescription() {
        return "Flattens items into their pressed variants";
    }

    public SpellTier defaultTier() {
        return SpellTier.TWO;
    }
}

