/*
 * Decompiled with CFR 0.152.
 */
package com.zeroregard.ars_technica.glyphs;

import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.spell.SpellTier;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAOE;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectSmelt;
import com.zeroregard.ars_technica.ArsTechnica;
import com.zeroregard.ars_technica.entity.fusion.ArcaneFusionEntity;
import com.zeroregard.ars_technica.glyphs.AugmentSuperheat;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.util.Color;

public class EffectFuse
extends AbstractEffect {
    public static EffectFuse INSTANCE = new EffectFuse(ArsTechnica.prefix("glyph_fuse"), "Fuse");

    private EffectFuse(ResourceLocation resourceLocation, String description) {
        super(resourceLocation, description);
    }

    public void onResolveEntity(EntityHitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        Entity target = rayTraceResult.getEntity();
        Vec3 position = target.getPosition(1.0f);
        this.resolve(target, position, world, shooter, spellStats, spellContext, resolver);
    }

    public void onResolveBlock(BlockHitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        Vec3 position = rayTraceResult.getLocation();
        this.resolve(null, position, world, shooter, spellStats, spellContext, resolver);
    }

    private void resolve(@Nullable Entity target, Vec3 position, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        Color color = new Color(spellContext.getColors().getColor());
        String fusionTypeId = this.getFusionType(spellStats, spellContext);
        SpellContext newContext = spellContext.makeChildContext();
        spellContext.setCanceled(true);
        ArcaneFusionEntity arcaneFusionEntity = new ArcaneFusionEntity(target, position, world, (Entity)shooter, color, resolver.getNewResolver(newContext), spellStats, fusionTypeId);
        world.addFreshEntity((Entity)arcaneFusionEntity);
    }

    private String getFusionType(SpellStats spellStats, SpellContext spellContext) {
        String fusionType = "regular";
        List augments = spellStats.getAugments();
        boolean hasSuperheat = augments.stream().anyMatch(augment -> augment instanceof AugmentSuperheat);
        if (hasSuperheat) {
            fusionType = "super";
            return fusionType;
        }
        if (spellContext.hasNextPart()) {
            while (spellContext.hasNextPart()) {
                AbstractSpellPart next = spellContext.nextPart();
                if (!(next instanceof AbstractEffect)) continue;
                if (next != EffectSmelt.INSTANCE) break;
                fusionType = "heated";
                break;
            }
        }
        return fusionType;
    }

    public int getDefaultManaCost() {
        return 75;
    }

    public void addAugmentDescriptions(Map<AbstractAugment, String> map) {
        super.addAugmentDescriptions(map);
        map.put((AbstractAugment)AugmentAOE.INSTANCE, "Increases the amount of items being processed");
        map.put(AugmentSuperheat.INSTANCE, "Switches to super-heated mixing");
    }

    @Nonnull
    public Set<AbstractAugment> getCompatibleAugments() {
        return this.augmentSetOf(new AbstractAugment[]{AugmentAOE.INSTANCE, AugmentSuperheat.INSTANCE});
    }

    @Nonnull
    public Set<SpellSchool> getSchools() {
        return this.setOf(new SpellSchool[]{SpellSchools.MANIPULATION});
    }

    public String getBookDescription() {
        return "Fuses items by slamming them together at breakneck speed. Use Smelt for heated mixing, use Superheat for super-heated mixing (if enabled in config)";
    }

    public SpellTier defaultTier() {
        return SpellTier.ONE;
    }
}

