/*
 * Decompiled with CFR 0.152.
 */
package com.zeroregard.ars_technica.entity.fusion.fluids;

import com.zeroregard.ars_technica.entity.fusion.ArcaneFusionEntity;
import com.zeroregard.ars_technica.entity.fusion.fluids.FluidSourceProvider;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class ArcaneFusionFluids {
    private final Level level;
    private final ArcaneFusionEntity parent;

    public ArcaneFusionFluids(ArcaneFusionEntity parent, Level level) {
        this.level = level;
        this.parent = parent;
    }

    public List<FluidSourceProvider> pickupFluids() {
        ArrayList<FluidSourceProvider> results = new ArrayList<FluidSourceProvider>();
        BlockPos center = new BlockPos(this.parent.getBlockX(), this.parent.getBlockY(), this.parent.getBlockZ());
        int range = 5;
        for (BlockPos pos : BlockPos.betweenClosed((BlockPos)center.offset(-range, -range, -range), (BlockPos)center.offset(range, range, range))) {
            FluidStack fluidStack;
            BlockState blockState = this.level.getBlockState(pos);
            FluidState fluidState = blockState.getFluidState();
            if (!fluidState.isEmpty() && fluidState.isSource()) {
                FluidStack fluidStack2 = new FluidStack(fluidState.getType(), fluidState.getAmount());
                results.add(new FluidSourceProvider(fluidStack2, pos, fluidState));
                continue;
            }
            BlockEntity blockEntity = this.level.getBlockEntity(pos);
            IFluidHandler fluidHandler = (IFluidHandler)Capabilities.FluidHandler.BLOCK.getCapability(this.level, pos, blockState, blockEntity, null);
            if (blockEntity == null || fluidHandler == null || (fluidStack = fluidHandler.drain(1000, IFluidHandler.FluidAction.SIMULATE)).isEmpty()) continue;
            results.add(new FluidSourceProvider(fluidStack, null, fluidHandler));
        }
        return results;
    }
}

