/*
 * Decompiled with CFR 0.152.
 */
package com.zeroregard.ars_technica.datagen;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.hollingsworth.arsnouveau.common.crafting.recipes.ImbuementRecipe;
import com.hollingsworth.arsnouveau.common.datagen.ApparatusRecipeBuilder;
import com.hollingsworth.arsnouveau.common.datagen.ApparatusRecipeProvider;
import com.hollingsworth.arsnouveau.common.datagen.ImbuementRecipeProvider;
import com.hollingsworth.arsnouveau.setup.registry.ItemsRegistry;
import com.mojang.serialization.Codec;
import com.simibubi.create.AllItems;
import com.zeroregard.ars_technica.datagen.Setup;
import com.zeroregard.ars_technica.item.PressurePerk;
import com.zeroregard.ars_technica.registry.ItemRegistry;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.conditions.IConditionBuilder;
import org.jetbrains.annotations.NotNull;

public class ArsProviders {
    static String root = "ars_technica";

    public static class CreateRecipeProvider
    implements DataProvider {
        private final DataGenerator generator;

        public CreateRecipeProvider(DataGenerator generatorIn) {
            this.generator = generatorIn;
        }

        @NotNull
        public CompletableFuture<?> run(@NotNull CachedOutput cache) {
            Path output = this.generator.getPackOutput().getOutputFolder();
            ArrayList futures = new ArrayList();
            futures.add(this.saveGrindingRecipe(cache, output, "giant_experience_gem", "ars_technica:giant_experience_gem", 48));
            futures.add(this.saveGrindingRecipe(cache, output, "gargantuan_experience_gem", "ars_technica:gargantuan_experience_gem", 192));
            return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
        }

        private CompletableFuture<?> saveGrindingRecipe(CachedOutput cache, Path output, String name, String item, int experience) {
            JsonObject json = new JsonObject();
            json.addProperty("type", "create_enchantment_industry:grinding");
            JsonArray ingredients = new JsonArray();
            JsonObject ingredient = new JsonObject();
            ingredient.addProperty("item", item);
            ingredients.add((JsonElement)ingredient);
            json.add("ingredients", (JsonElement)ingredients);
            JsonArray results = new JsonArray();
            JsonObject result = new JsonObject();
            result.addProperty("amount", (Number)experience);
            result.addProperty("id", "create_enchantment_industry:experience");
            results.add((JsonElement)result);
            json.add("results", (JsonElement)results);
            Path path = output.resolve("data/create_enchantment_industry/recipe/grinding/ars_technica/" + name + ".json");
            return DataProvider.saveStable((CachedOutput)cache, (JsonElement)json, (Path)path);
        }

        @NotNull
        public String getName() {
            return "Create Grinding Recipes";
        }
    }

    public static class ArmorUpgradeProvider
    implements DataProvider {
        private final DataGenerator generator;

        public ArmorUpgradeProvider(DataGenerator generatorIn) {
            this.generator = generatorIn;
        }

        @NotNull
        public CompletableFuture<?> run(@NotNull CachedOutput cache) {
            Path output = this.generator.getPackOutput().getOutputFolder();
            ArrayList futures = new ArrayList();
            futures.add(this.saveArmorUpgradeRecipe(cache, output, "technomancer_helmet", "ars_elemental:mark_of_mastery", "ars_nouveau:magic_hood", "ars_technica:technomancer_helmet", List.of("ars_elemental:mark_of_mastery", "c:ingots/netherite", "c:ingots/brass", "create:goggles"), true));
            futures.add(this.saveArmorUpgradeRecipe(cache, output, "technomancer_chestplate", "ars_elemental:mark_of_mastery", "ars_nouveau:magic_robe", "ars_technica:technomancer_chestplate", List.of("ars_elemental:mark_of_mastery", "c:ingots/netherite", "c:ingots/brass", "c:ingots/brass"), true));
            futures.add(this.saveArmorUpgradeRecipe(cache, output, "technomancer_leggings", "ars_elemental:mark_of_mastery", "ars_nouveau:magic_legs", "ars_technica:technomancer_leggings", List.of("ars_elemental:mark_of_mastery", "c:ingots/netherite", "c:ingots/brass", "c:ingots/brass"), true));
            futures.add(this.saveArmorUpgradeRecipe(cache, output, "technomancer_boots", "ars_elemental:mark_of_mastery", "ars_nouveau:magic_boots", "ars_technica:technomancer_boots", List.of("ars_elemental:mark_of_mastery", "c:ingots/netherite", "c:ingots/brass", "c:ingots/brass"), true));
            futures.add(this.saveArmorUpgradeRecipe(cache, output, "technomancer_helmet_default", "ars_technica:mark_of_technomancy", "ars_nouveau:magic_hood", "ars_technica:technomancer_helmet", List.of("ars_technica:mark_of_technomancy", "c:ingots/netherite", "c:ingots/brass", "create:goggles"), false));
            futures.add(this.saveArmorUpgradeRecipe(cache, output, "technomancer_chestplate_default", "ars_technica:mark_of_technomancy", "ars_nouveau:magic_robe", "ars_technica:technomancer_chestplate", List.of("ars_technica:mark_of_technomancy", "c:ingots/netherite", "c:ingots/brass", "c:ingots/brass"), false));
            futures.add(this.saveArmorUpgradeRecipe(cache, output, "technomancer_leggings_default", "ars_technica:mark_of_technomancy", "ars_nouveau:magic_legs", "ars_technica:technomancer_leggings", List.of("ars_technica:mark_of_technomancy", "c:ingots/netherite", "c:ingots/brass", "c:ingots/brass"), false));
            futures.add(this.saveArmorUpgradeRecipe(cache, output, "technomancer_boots_default", "ars_technica:mark_of_technomancy", "ars_nouveau:magic_boots", "ars_technica:technomancer_boots", List.of("ars_technica:mark_of_technomancy", "c:ingots/netherite", "c:ingots/brass", "c:ingots/brass"), false));
            return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
        }

        private CompletableFuture<?> saveArmorUpgradeRecipe(CachedOutput cache, Path output, String name, String markItem, String reagentTag, String resultItem, List<String> pedestalItems, boolean conditional) {
            JsonObject json = new JsonObject();
            if (conditional) {
                JsonArray conditions = new JsonArray();
                JsonObject condition = new JsonObject();
                condition.addProperty("type", "neoforge:mod_loaded");
                condition.addProperty("modid", "ars_elemental");
                conditions.add((JsonElement)condition);
                json.add("neoforge:conditions", (JsonElement)conditions);
            }
            json.addProperty("type", "ars_technica:armor_upgrade");
            JsonArray pedestalArray = new JsonArray();
            for (String item : pedestalItems) {
                JsonObject pedestalItem = new JsonObject();
                if (item.contains(":") && !item.startsWith("c:")) {
                    pedestalItem.addProperty("item", item);
                } else {
                    pedestalItem.addProperty("tag", item);
                }
                pedestalArray.add((JsonElement)pedestalItem);
            }
            json.add("pedestalItems", (JsonElement)pedestalArray);
            JsonObject reagent = new JsonObject();
            reagent.addProperty("tag", reagentTag);
            json.add("reagent", (JsonElement)reagent);
            JsonObject result = new JsonObject();
            result.addProperty("count", (Number)1);
            result.addProperty("id", resultItem);
            json.add("result", (JsonElement)result);
            json.addProperty("sourceCost", (Number)7000);
            json.addProperty("keepNbtOfReagent", Boolean.valueOf(true));
            Path path = output.resolve("data/" + root + "/recipe/" + name + ".json");
            return DataProvider.saveStable((CachedOutput)cache, (JsonElement)json, (Path)path);
        }

        @NotNull
        public String getName() {
            return "Armor Upgrade Recipes";
        }
    }

    public static class CraftingProvider
    extends RecipeProvider {
        public CraftingProvider(DataGenerator generatorIn) {
            super(generatorIn.getPackOutput(), Setup.provider);
        }

        protected void buildRecipes(@NotNull RecipeOutput output) {
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ItemRegistry.SOURCE_MOTOR.get())).pattern("BEB").pattern("CSC").pattern("BCB").define(Character.valueOf('B'), Ingredient.fromValues(Stream.of(new Ingredient.TagValue(TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"ingots/brass")))))).define(Character.valueOf('C'), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"create", (String)"cogwheel"))})).define(Character.valueOf('S'), (ItemLike)ItemRegistry.CALIBRATED_PRECISION_MECHANISM.get()).define(Character.valueOf('E'), (ItemLike)AllItems.ELECTRON_TUBE.get()).unlockedBy("has_calibrated_precision_mechanism", CraftingProvider.has((ItemLike)((ItemLike)ItemRegistry.CALIBRATED_PRECISION_MECHANISM.get()))).save(output);
            ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ItemRegistry.GIANT_EXPERIENCE_GEM.get())).requires((ItemLike)ItemsRegistry.GREATER_EXPERIENCE_GEM.get(), 4).unlockedBy("has_greater_experience_gem", CraftingProvider.has((ItemLike)((ItemLike)ItemsRegistry.GREATER_EXPERIENCE_GEM.get()))).save(output);
            ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ItemRegistry.GARGANTUAN_EXPERIENCE_GEM.get())).requires((ItemLike)ItemRegistry.GIANT_EXPERIENCE_GEM.get(), 4).unlockedBy("has_giant_experience_gem", CraftingProvider.has((ItemLike)((ItemLike)ItemRegistry.GIANT_EXPERIENCE_GEM.get()))).save(output);
            ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ItemsRegistry.GREATER_EXPERIENCE_GEM.get()), (int)4).requires((ItemLike)ItemRegistry.GIANT_EXPERIENCE_GEM.get()).unlockedBy("has_giant_experience_gem", CraftingProvider.has((ItemLike)((ItemLike)ItemRegistry.GIANT_EXPERIENCE_GEM.get()))).save(output, ResourceLocation.fromNamespaceAndPath((String)root, (String)"greater_from_giant_experience_gem"));
            ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ItemRegistry.GIANT_EXPERIENCE_GEM.get()), (int)4).requires((ItemLike)ItemRegistry.GARGANTUAN_EXPERIENCE_GEM.get()).unlockedBy("has_gargantuan_experience_gem", CraftingProvider.has((ItemLike)((ItemLike)ItemRegistry.GARGANTUAN_EXPERIENCE_GEM.get()))).save(output, ResourceLocation.fromNamespaceAndPath((String)root, (String)"giant_from_gargantuan_experience_gem"));
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ItemRegistry.POCKET_FACTORY.get())).pattern(" S ").pattern("GBG").pattern(" S ").define(Character.valueOf('S'), Ingredient.fromValues(Stream.of(new Ingredient.TagValue(TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"plates/brass")))))).define(Character.valueOf('G'), (ItemLike)ItemsRegistry.SOURCE_GEM.get()).define(Character.valueOf('B'), Ingredient.fromValues(Stream.of(new Ingredient.TagValue(TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"blank_music_disc")))))).unlockedBy("has_blank_disc", CraftingProvider.has((ItemLike)((ItemLike)ItemRegistry.BLANK_DISC.get()))).save(output);
        }
    }

    public static class DyeProvider
    implements DataProvider {
        private final DataGenerator generator;

        public DyeProvider(DataGenerator generatorIn) {
            this.generator = generatorIn;
        }

        @NotNull
        public CompletableFuture<?> run(@NotNull CachedOutput cache) {
            Path output = this.generator.getPackOutput().getOutputFolder();
            ArrayList futures = new ArrayList();
            futures.add(this.saveDyeRecipe(cache, output, "dye_techno_hat", "ars_technica:technomancer_helmet"));
            futures.add(this.saveDyeRecipe(cache, output, "dye_techno_robes", "ars_technica:technomancer_chestplate"));
            futures.add(this.saveDyeRecipe(cache, output, "dye_techno_leggings", "ars_technica:technomancer_leggings"));
            futures.add(this.saveDyeRecipe(cache, output, "dye_techno_boots", "ars_technica:technomancer_boots"));
            return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
        }

        private CompletableFuture<?> saveDyeRecipe(CachedOutput cache, Path output, String name, String armorItem) {
            JsonObject json = new JsonObject();
            json.addProperty("type", "ars_nouveau:dye");
            json.addProperty("category", "misc");
            JsonArray ingredients = new JsonArray();
            JsonObject dyeIngredient = new JsonObject();
            dyeIngredient.addProperty("tag", "c:dyes");
            ingredients.add((JsonElement)dyeIngredient);
            JsonObject armorIngredient = new JsonObject();
            armorIngredient.addProperty("item", armorItem);
            ingredients.add((JsonElement)armorIngredient);
            json.add("ingredients", (JsonElement)ingredients);
            JsonObject result = new JsonObject();
            result.addProperty("count", (Number)1);
            result.addProperty("id", armorItem);
            json.add("result", (JsonElement)result);
            Path path = output.resolve("data/" + root + "/recipe/" + name + ".json");
            return DataProvider.saveStable((CachedOutput)cache, (JsonElement)json, (Path)path);
        }

        @NotNull
        public String getName() {
            return "Dye Recipes";
        }
    }

    public static class GlyphProvider
    implements DataProvider {
        private final DataGenerator generator;

        public GlyphProvider(DataGenerator generatorIn) {
            this.generator = generatorIn;
        }

        @NotNull
        public CompletableFuture<?> run(@NotNull CachedOutput cache) {
            Path output = this.generator.getPackOutput().getOutputFolder();
            ArrayList futures = new ArrayList();
            futures.add(this.saveGlyphRecipe(cache, output, "glyph_carve", 27, List.of("ars_nouveau:manipulation_essence", "minecraft:crafting_table", "minecraft:cobblestone_stairs", "minecraft:cobblestone_slab", "minecraft:cobblestone_wall"), "ars_technica:glyph_carve"));
            futures.add(this.saveGlyphRecipe(cache, output, "glyph_pack", 27, List.of("ars_nouveau:manipulation_essence", "minecraft:crafting_table", "minecraft:chest", "minecraft:iron_block"), "ars_technica:glyph_pack"));
            futures.add(this.saveGlyphRecipe(cache, output, "glyph_polish", 55, List.of("ars_nouveau:manipulation_essence", "create:sand_paper"), "ars_technica:glyph_polish"));
            futures.add(this.saveGlyphRecipe(cache, output, "glyph_obliterate", 160, List.of("ars_nouveau:manipulation_essence", "minecraft:anvil", "minecraft:diamond_block"), "ars_technica:glyph_obliterate"));
            futures.add(this.saveGlyphRecipe(cache, output, "glyph_press", 55, List.of("ars_nouveau:manipulation_essence", "create:mechanical_press"), "ars_technica:glyph_press"));
            futures.add(this.saveGlyphRecipe(cache, output, "glyph_superheat", 160, List.of("ars_nouveau:fire_essence", "ars_nouveau:fire_essence", "ars_nouveau:fire_essence", "minecraft:blaze_rod", "create:blaze_cake"), "ars_technica:glyph_superheat"));
            futures.add(this.saveGlyphRecipe(cache, output, "glyph_fuse", 55, List.of("ars_nouveau:manipulation_essence", "ars_nouveau:fire_essence", "minecraft:blaze_rod", "minecraft:blaze_rod", "minecraft:blaze_rod"), "ars_technica:glyph_fuse"));
            futures.add(this.saveGlyphRecipe(cache, output, "glyph_whirl", 55, List.of("ars_nouveau:manipulation_essence", "ars_nouveau:air_essence", "ars_nouveau:air_essence", "ars_nouveau:air_essence"), "ars_technica:glyph_whirl"));
            futures.add(this.saveGlyphRecipe(cache, output, "glyph_insert", 27, List.of("minecraft:chest", "minecraft:chest"), "ars_technica:glyph_insert"));
            futures.add(this.saveGlyphRecipe(cache, output, "glyph_telefeast", 55, List.of("ars_nouveau:manipulation_essence", "minecraft:golden_apple", "minecraft:bucket", "minecraft:glass_bottle", "minecraft:ender_pearl"), "ars_technica:glyph_telefeast"));
            futures.add(this.saveGlyphRecipe(cache, output, "glyph_apply", 27, List.of("ars_nouveau:manipulation_essence", "create:brass_hand"), "ars_technica:glyph_apply"));
            return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
        }

        private CompletableFuture<?> saveGlyphRecipe(CachedOutput cache, Path output, String name, int exp, List<String> inputs, String result) {
            JsonObject json = new JsonObject();
            json.addProperty("type", "ars_nouveau:glyph");
            json.addProperty("exp", (Number)exp);
            JsonArray inputsArray = new JsonArray();
            for (String input : inputs) {
                JsonObject inputObj = new JsonObject();
                inputObj.addProperty("item", input);
                inputsArray.add((JsonElement)inputObj);
            }
            json.add("inputs", (JsonElement)inputsArray);
            JsonObject outputObj = new JsonObject();
            outputObj.addProperty("count", (Number)1);
            outputObj.addProperty("id", result);
            json.add("output", (JsonElement)outputObj);
            Path path = output.resolve("data/" + root + "/recipe/" + name + ".json");
            return DataProvider.saveStable((CachedOutput)cache, (JsonElement)json, (Path)path);
        }

        @NotNull
        public String getName() {
            return "Glyph Recipes";
        }
    }

    public static class ImbuementProvider
    extends ImbuementRecipeProvider {
        public ImbuementProvider(DataGenerator generatorIn) {
            super(generatorIn);
        }

        @NotNull
        public CompletableFuture<?> run(@NotNull CachedOutput pOutput) {
            this.collectJsons(pOutput);
            ArrayList futures = new ArrayList();
            return Setup.provider.thenCompose(registry -> {
                for (ImbuementRecipe g : this.recipes) {
                    Path path = this.getRecipePath(this.output, g.id.getPath());
                    futures.add(DataProvider.saveStable((CachedOutput)pOutput, (HolderLookup.Provider)registry, (Codec)ImbuementRecipe.CODEC, (Object)g, (Path)path));
                }
                return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
            });
        }

        public void collectJsons(CachedOutput cache) {
        }

        protected Path getRecipePath(Path pathIn, String str) {
            return pathIn.resolve("data/" + root + "/recipe/" + str + ".json");
        }

        @NotNull
        public String getName() {
            return "Example Imbuement";
        }
    }

    public static class EnchantingAppProvider
    extends ApparatusRecipeProvider
    implements IConditionBuilder {
        public EnchantingAppProvider(DataGenerator generatorIn) {
            super(generatorIn);
        }

        public void collectJsons(CachedOutput cache) {
            this.addIngredientRecipes();
            this.addEquipmentRecipes();
            this.addCurioRecipes();
            this.addThreadRecipes();
            Path output = this.generator.getPackOutput().getOutputFolder();
            for (ApparatusRecipeBuilder.RecipeWrapper g : this.recipes) {
                if (g == null) continue;
                Path path = EnchantingAppProvider.getRecipePath(output, g.id().getPath());
                this.saveStable(cache, g.serialize(), path);
            }
        }

        protected void addIngredientRecipes() {
            this.recipes.add(this.builder().withResult(ItemRegistry.CALIBRATED_PRECISION_MECHANISM).withReagent((ItemLike)AllItems.PRECISION_MECHANISM).withPedestalItem(4, Ingredient.of((ItemLike[])new ItemLike[]{Items.AMETHYST_SHARD})).withPedestalItem(4, Ingredient.of((ItemLike[])new ItemLike[]{ItemsRegistry.SOURCE_GEM})).withSourceCost(500).build());
            this.recipes.add(this.builder().withResult(new ItemStack((ItemLike)ItemRegistry.MARK_OF_TECHNOMANCY.get(), 5)).withReagent((ItemLike)ItemsRegistry.WILDEN_TRIBUTE).withPedestalItem((ItemLike)AllItems.PRECISION_MECHANISM).withPedestalItem(ItemRegistry.CALIBRATED_PRECISION_MECHANISM).withPedestalItem((ItemLike)ItemsRegistry.MANIPULATION_ESSENCE).withPedestalItem(Ingredient.fromValues(Stream.of(new Ingredient.TagValue(TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"ingots/iron")))))).withPedestalItem(Ingredient.fromValues(Stream.of(new Ingredient.TagValue(TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"ingots/copper")))))).withPedestalItem(Ingredient.fromValues(Stream.of(new Ingredient.TagValue(TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"plates/brass")))))).withPedestalItem(Ingredient.fromValues(Stream.of(new Ingredient.TagValue(TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"ingots/zinc")))))).withPedestalItem(Ingredient.fromValues(Stream.of(new Ingredient.TagValue(TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"plates/gold")))))).withSourceCost(10000).build());
        }

        protected void addEquipmentRecipes() {
            this.recipes.add(this.builder().withResult(ItemRegistry.RUNIC_SPANNER).withReagent((ItemLike)AllItems.WRENCH).withPedestalItem(Ingredient.fromValues(Stream.of(new Ingredient.TagValue(TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"ingots/gold")))))).withPedestalItem(Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)ItemRegistry.CALIBRATED_PRECISION_MECHANISM.get())})).withPedestalItem(Ingredient.of((ItemLike[])new ItemLike[]{ItemsRegistry.MANIPULATION_ESSENCE})).withSourceCost(500).build());
            this.recipes.add(this.builder().withResult(ItemRegistry.BLANK_DISC).withReagent(Ingredient.fromValues(Stream.of(new Ingredient.TagValue(TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"music_discs")))))).withPedestalItem(Ingredient.of((ItemLike[])new ItemLike[]{ItemsRegistry.FIRE_ESSENCE})).withSourceCost(0).build());
        }

        protected void addCurioRecipes() {
            this.recipes.add(this.builder().withResult(ItemRegistry.TRANSMUTATION_FOCUS).withReagent((ItemLike)ItemsRegistry.MANIPULATION_ESSENCE).withPedestalItem(1, Ingredient.fromValues(Stream.of(new Ingredient.TagValue(TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"ingots/brass")))))).withPedestalItem((ItemLike)Items.RABBIT_FOOT).withPedestalItem(ItemRegistry.CALIBRATED_PRECISION_MECHANISM).withPedestalItem(Ingredient.of((ItemLike[])new ItemLike[]{Items.EMERALD})).build());
            this.recipes.add(this.builder().withResult(ItemRegistry.SPY_MONOCLE).withReagent((ItemLike)Items.SPYGLASS).withPedestalItem(Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)ItemRegistry.CALIBRATED_PRECISION_MECHANISM.get())})).build());
        }

        protected void addThreadRecipes() {
            this.recipes.add(this.builder().withResult((ItemLike)this.getPerkItem(PressurePerk.INSTANCE.getRegistryName())).withReagent((ItemLike)ItemsRegistry.BLANK_THREAD).withPedestalItem(3, Ingredient.of((ItemLike[])new ItemLike[]{ItemsRegistry.AIR_ESSENCE})).withPedestalItem(Ingredient.of((ItemLike[])new ItemLike[]{AllItems.COPPER_BACKTANK})).withPedestalItem(Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)ItemRegistry.CALIBRATED_PRECISION_MECHANISM.get())})).build());
        }

        protected static Path getRecipePath(Path pathIn, String str) {
            return pathIn.resolve("data/" + root + "/recipe/" + str + ".json");
        }

        @NotNull
        public String getName() {
            return "Example Apparatus";
        }
    }
}

