/*
 * Decompiled with CFR 0.152.
 */
package com.zeroregard.ars_technica.client.sound;

import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;

public class EntityLoopingSound
extends AbstractTickableSoundInstance {
    private final Entity entity;
    private final double maxDistance = 16.0;
    private final float maxVolume;
    private final double maxDistanceSquared = 256.0;

    public EntityLoopingSound(Entity entity, SoundEvent sound, float volume, float pitch) {
        super(sound, SoundSource.AMBIENT, RandomSource.create());
        this.entity = entity;
        this.looping = true;
        this.delay = 0;
        this.volume = volume;
        this.maxVolume = volume;
        this.pitch = pitch;
        this.attenuation = SoundInstance.Attenuation.LINEAR;
        this.x = entity.getX();
        this.y = entity.getY();
        this.z = entity.getZ();
    }

    public void setPitch(float pitch) {
        this.pitch = pitch;
    }

    public void tick() {
        double distanceSquared;
        if (!this.entity.isAlive()) {
            this.stop();
            return;
        }
        this.x = this.entity.getX();
        this.y = this.entity.getY();
        this.z = this.entity.getZ();
        Minecraft minecraft = Minecraft.getInstance();
        if (minecraft.player != null && (distanceSquared = minecraft.player.distanceToSqr(this.x, this.y, this.z)) <= 256.0) {
            float distanceFactor = (float)Math.sqrt(distanceSquared) / 16.0f;
            this.volume = Math.max(0.0f, 1.0f - distanceFactor) * this.maxVolume;
        }
    }
}

