/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.enchantableblocks.datagen;

import com.mrbysco.enchantableblocks.datagen.assets.EnchantableBlockstateProvider;
import com.mrbysco.enchantableblocks.datagen.assets.EnchantableLanguageProvider;
import com.mrbysco.enchantableblocks.datagen.data.EnchantableBlockTagsProvider;
import com.mrbysco.enchantableblocks.datagen.data.EnchantableEnchantmentTagsProvider;
import com.mrbysco.enchantableblocks.datagen.data.EnchantableItemTagsProvider;
import com.mrbysco.enchantableblocks.datagen.data.EnchantableLootProvider;
import com.mrbysco.enchantableblocks.datagen.data.EnchantablePoiTypeTagsProvider;
import com.mrbysco.enchantableblocks.registry.ModEnchantments;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.Cloner;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.registries.VanillaRegistries;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.DatapackBuiltinEntriesProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.registries.DataPackRegistriesHooks;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class EnchantableDatagen {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        CompletableFuture<HolderLookup.Provider> lookupProvider = CompletableFuture.supplyAsync(() -> EnchantableDatagen.getProvider().full());
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        if (event.includeServer()) {
            generator.addProvider(event.includeServer(), (DataProvider)new DatapackBuiltinEntriesProvider(packOutput, CompletableFuture.supplyAsync(EnchantableDatagen::getProvider), Set.of("enchantableblocks")));
            generator.addProvider(true, (DataProvider)new EnchantableLootProvider(packOutput, lookupProvider));
            EnchantableBlockTagsProvider blockTagProvider = new EnchantableBlockTagsProvider(packOutput, lookupProvider, existingFileHelper);
            generator.addProvider(true, (DataProvider)blockTagProvider);
            generator.addProvider(true, (DataProvider)new EnchantableItemTagsProvider(packOutput, lookupProvider, blockTagProvider.contentsGetter(), existingFileHelper));
            generator.addProvider(true, (DataProvider)new EnchantablePoiTypeTagsProvider(packOutput, lookupProvider, existingFileHelper));
            generator.addProvider(true, (DataProvider)new EnchantableEnchantmentTagsProvider(packOutput, lookupProvider, existingFileHelper));
        }
        if (event.includeClient()) {
            generator.addProvider(true, (DataProvider)new EnchantableLanguageProvider(packOutput));
            generator.addProvider(true, (DataProvider)new EnchantableBlockstateProvider(packOutput, existingFileHelper));
        }
    }

    private static RegistrySetBuilder.PatchedRegistries getProvider() {
        RegistrySetBuilder registryBuilder = new RegistrySetBuilder();
        registryBuilder.add(Registries.ENCHANTMENT, ModEnchantments::bootstrap);
        RegistryAccess.Frozen regAccess = RegistryAccess.fromRegistryOfRegistries((Registry)BuiltInRegistries.REGISTRY);
        Cloner.Factory cloner$factory = new Cloner.Factory();
        DataPackRegistriesHooks.getDataPackRegistriesWithDimensions().forEach(data -> data.runWithArguments((arg_0, arg_1) -> ((Cloner.Factory)cloner$factory).addCodec(arg_0, arg_1)));
        return registryBuilder.buildPatch((RegistryAccess)regAccess, VanillaRegistries.createLookup(), cloner$factory);
    }
}

